/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.datatype;

import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtBoolean;
import cn.weforward.protocol.datatype.DtDate;
import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.exception.DataTypeCastExecption;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.support.NamingConverter;
import cn.weforward.protocol.support.datatype.FriendlyList;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class FriendlyObject {
    static final FriendlyObject NIL = new FriendlyObject(null);
    protected final DtObject m_Object;
    protected final boolean m_Suppress;

    public FriendlyObject(DtObject obj) {
        this(obj, false);
    }

    public FriendlyObject(DtObject obj, boolean suppress) {
        this.m_Object = obj;
        this.m_Suppress = suppress;
    }

    public static FriendlyObject valueOf(DtObject obj) {
        return FriendlyObject.valueOf(obj, false);
    }

    public static FriendlyObject valueOf(DtObject obj, boolean suppress) {
        if (obj == null) {
            return NIL;
        }
        return new FriendlyObject(obj, suppress);
    }

    public DtObject dtObjectValue() {
        return this.m_Object;
    }

    public int getInt(String name) throws DataTypeCastExecption {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int defalutValue) throws DataTypeCastExecption {
        return FriendlyObject.getInt(this.m_Object, name, defalutValue, this.m_Suppress);
    }

    public static int getInt(DtObject object, String name) throws DataTypeCastExecption {
        return FriendlyObject.getInt(object, name, 0, false);
    }

    public static int getInt(DtObject object, String name, int defalutValue) throws DataTypeCastExecption {
        return FriendlyObject.getInt(object, name, defalutValue, false);
    }

    public static int getInt(DtObject object, String name, int defalutValue, boolean suppress) throws DataTypeCastExecption {
        DtNumber num = FriendlyObject.getNumber(object, name, suppress);
        if (num == null) {
            return defalutValue;
        }
        return num.valueInt();
    }

    public long getLong(String name) throws DataTypeCastExecption {
        return this.getLong(name, 0L);
    }

    public long getLong(String name, long defalutValue) throws DataTypeCastExecption {
        return FriendlyObject.getLong(this.m_Object, name, defalutValue, this.m_Suppress);
    }

    public static long getLong(DtObject object, String name) throws DataTypeCastExecption {
        return FriendlyObject.getLong(object, name, 0L, false);
    }

    public static long getLong(DtObject object, String name, long defalutValue) throws DataTypeCastExecption {
        return FriendlyObject.getLong(object, name, defalutValue, false);
    }

    public static long getLong(DtObject object, String name, long defalutValue, boolean suppress) throws DataTypeCastExecption {
        DtNumber num = FriendlyObject.getNumber(object, name, suppress);
        if (num == null) {
            return defalutValue;
        }
        return num.valueLong();
    }

    public double getDouble(String name) throws DataTypeCastExecption {
        return this.getDouble(name, 0.0);
    }

    public double getDouble(String name, double defalutValue) throws DataTypeCastExecption {
        return FriendlyObject.getDouble(this.m_Object, name, defalutValue, this.m_Suppress);
    }

    public static double getDouble(DtObject object, String name) throws DataTypeCastExecption {
        return FriendlyObject.getDouble(object, name, 0.0, false);
    }

    public static double getDouble(DtObject object, String name, double defalutValue) throws DataTypeCastExecption {
        return FriendlyObject.getDouble(object, name, defalutValue, false);
    }

    public static double getDouble(DtObject object, String name, double defalutValue, boolean suppress) throws DataTypeCastExecption {
        DtNumber num = FriendlyObject.getNumber(object, name, suppress);
        if (num == null) {
            return defalutValue;
        }
        return num.valueDouble();
    }

    protected static DtNumber getNumber(DtObject object, String name, boolean suppress) {
        if (object == null) {
            return null;
        }
        name = NamingConverter.camelToWf(name);
        try {
            return object.getNumber(name);
        }
        catch (DataTypeCastExecption e) {
            if (suppress) {
                return null;
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (suppress) {
                return null;
            }
            throw new DataTypeCastExecption(e);
        }
    }

    public String getString(String name) throws DataTypeCastExecption {
        return FriendlyObject.getString(this.m_Object, name, this.m_Suppress);
    }

    public static String getString(DtObject object, String name) {
        return FriendlyObject.getString(object, name, false);
    }

    public static String getString(DtObject object, String name, boolean suppress) throws DataTypeCastExecption {
        DtString str;
        if (object == null) {
            return null;
        }
        name = NamingConverter.camelToWf(name);
        try {
            str = object.getString(name);
        }
        catch (DataTypeCastExecption e) {
            if (suppress) {
                return null;
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (suppress) {
                return null;
            }
            throw new DataTypeCastExecption(e);
        }
        if (str == null) {
            return null;
        }
        return str.value();
    }

    public Date getDate(String name) throws DataTypeCastExecption {
        return FriendlyObject.getDate(this.m_Object, name, this.m_Suppress);
    }

    public static Date getDate(DtObject object, String name) throws DataTypeCastExecption {
        return FriendlyObject.getDate(object, name, false);
    }

    public static Date getDate(DtObject object, String name, boolean suppress) throws DataTypeCastExecption {
        DtDate d;
        if (object == null) {
            return null;
        }
        name = NamingConverter.camelToWf(name);
        try {
            d = object.getDate(name);
        }
        catch (DataTypeCastExecption e) {
            if (suppress) {
                return null;
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (suppress) {
                return null;
            }
            throw new DataTypeCastExecption(e);
        }
        if (d == null) {
            return null;
        }
        return d.valueDate();
    }

    public boolean getBoolean(String name, boolean defalutValue) {
        return FriendlyObject.getBoolean(this.m_Object, name, defalutValue, this.m_Suppress);
    }

    public static boolean getBoolean(DtObject object, String name, boolean defalutValue) {
        return FriendlyObject.getBoolean(object, name, defalutValue, false);
    }

    public static boolean getBoolean(DtObject object, String name, boolean defalutValue, boolean suppress) {
        DtBoolean bool;
        if (object == null) {
            return defalutValue;
        }
        name = NamingConverter.camelToWf(name);
        try {
            bool = object.getBoolean(name);
        }
        catch (DataTypeCastExecption e) {
            if (suppress) {
                return defalutValue;
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (suppress) {
                return defalutValue;
            }
            throw new DataTypeCastExecption(e);
        }
        if (bool == null) {
            return defalutValue;
        }
        return bool.value();
    }

    public DtObject getObject(String name) {
        return FriendlyObject.getObject(this.m_Object, name, this.m_Suppress);
    }

    public static DtObject getObject(DtObject object, String name) {
        return FriendlyObject.getObject(object, name, false);
    }

    public static DtObject getObject(DtObject object, String name, boolean suppress) {
        DtObject obj;
        if (object == null) {
            return null;
        }
        name = NamingConverter.camelToWf(name);
        try {
            obj = object.getObject(name);
        }
        catch (DataTypeCastExecption e) {
            if (suppress) {
                return null;
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (suppress) {
                return null;
            }
            throw new DataTypeCastExecption(e);
        }
        return obj;
    }

    public DtBase getBase(String name) {
        return FriendlyObject.getBase(this.m_Object, name);
    }

    public static DtBase getBase(DtObject object, String name) {
        name = NamingConverter.camelToWf(name);
        return object.getAttribute(name);
    }

    public <E> E getObject(String name, Class<E> clazz, ObjectMapperSet mappers) throws DataTypeCastExecption, ObjectMappingException {
        DtObject obj = this.getObject(name);
        if (obj == null) {
            return null;
        }
        ObjectMapper<E> mapper = mappers.getObjectMapper(clazz);
        if (mapper == null) {
            throw new ObjectMappingException("\u4e0d\u652f\u6301\u6620\u5c04\u6b64\u7c7b\u578b\uff1a" + clazz);
        }
        return mapper.fromDtObject(obj);
    }

    public <E> E getObject(String name, ObjectMapper<E> mapper) {
        return FriendlyObject.getObject(this.m_Object, name, mapper, this.m_Suppress);
    }

    public static <E> E getObject(DtObject object, String name, ObjectMapper<E> mapper, boolean suppress) {
        DtObject obj = FriendlyObject.getObject(object, name, suppress);
        if (obj == null) {
            return null;
        }
        return mapper.fromDtObject(obj);
    }

    public DtList getList(String name) {
        return FriendlyObject.getList(this.m_Object, name, this.m_Suppress);
    }

    public static DtList getList(DtObject object, String name) {
        return FriendlyObject.getList(object, name, false);
    }

    public static DtList getList(DtObject object, String name, boolean suppress) {
        DtList list;
        if (object == null) {
            return null;
        }
        name = NamingConverter.camelToWf(name);
        try {
            list = object.getList(name);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            if (suppress) {
                return null;
            }
            throw new DataTypeCastExecption(e);
        }
        return list;
    }

    public <E> List<E> getList(String name, Class<E> clazz, ObjectMapperSet mappers) {
        ObjectMapper<E> mapper = mappers.getObjectMapper(clazz);
        if (mapper == null) {
            throw new ObjectMappingException("\u4e0d\u652f\u6301\u6620\u5c04\u6b64\u7c7b\u578b\uff1a" + clazz);
        }
        return this.getList(name, mapper);
    }

    public <E> List<E> getList(String name, ObjectMapper<E> mapper) {
        return FriendlyObject.getList(this.m_Object, name, mapper, this.m_Suppress);
    }

    public static <E> List<E> getList(DtObject object, String name, ObjectMapper<E> mapper) {
        return FriendlyObject.getList(object, name, mapper, false);
    }

    public static <E> List<E> getList(DtObject object, String name, final ObjectMapper<E> mapper, boolean suppress) {
        final DtList list = FriendlyObject.getList(object, name, suppress);
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                DtObject obj = (DtObject)list.getItem(index);
                return mapper.fromDtObject(obj);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public <E> E toObject(Class<E> clazz, ObjectMapperSet mappers) throws ObjectMappingException {
        return FriendlyObject.toObject(this.m_Object, clazz, mappers);
    }

    public static <E> E toObject(DtObject object, Class<E> clazz, ObjectMapperSet mappers) throws ObjectMappingException {
        if (object == null) {
            return null;
        }
        ObjectMapper<E> mapper = mappers.getObjectMapper(clazz);
        if (mapper == null) {
            throw new ObjectMappingException("\u4e0d\u652f\u6301\u6620\u5c04\u6b64\u7c7b\u578b\uff1a" + clazz);
        }
        return mapper.fromDtObject(object);
    }

    public <E> E toObject(ObjectMapper<E> mapper) throws ObjectMappingException {
        return FriendlyObject.toObject(this.m_Object, mapper);
    }

    public static <E> E toObject(DtObject object, ObjectMapper<E> mapper) throws ObjectMappingException {
        if (object == null) {
            return null;
        }
        return mapper.fromDtObject(object);
    }

    public boolean isNull() {
        return this.m_Object == null;
    }

    public boolean isAttributeExisted(String name) {
        return this.m_Object.getAttribute(name) != null;
    }

    public FriendlyObject getFriendlyObject(String name) {
        return FriendlyObject.valueOf(this.getObject(name), this.m_Suppress);
    }

    public static FriendlyObject getFriendlyObject(DtObject object, String name) {
        return FriendlyObject.getFriendlyObject(object, name, false);
    }

    public static FriendlyObject getFriendlyObject(DtObject object, String name, boolean suppress) {
        DtObject sub = FriendlyObject.getObject(object, name, suppress);
        return FriendlyObject.valueOf(sub, suppress);
    }

    public FriendlyList getFriendlyList(String name) {
        return FriendlyList.valueOf(this.getList(name), this.m_Suppress);
    }

    public static FriendlyList getFriendlyList(DtObject object, String name) {
        return FriendlyObject.getFriendlyList(object, name, false);
    }

    public static FriendlyList getFriendlyList(DtObject object, String name, boolean suppress) {
        DtList list = FriendlyObject.getList(object, name, suppress);
        return FriendlyList.valueOf(list, suppress);
    }
}

