/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.datatype;

import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.datatype.DataType;
import cn.weforward.protocol.datatype.DtBoolean;
import cn.weforward.protocol.exception.DataTypeCastExecption;

public class SimpleDtBoolean
implements DtBoolean {
    public static final DtBoolean TRUE = new DtBoolean(){

        @Override
        public DataType type() {
            return DataType.BOOLEAN;
        }

        @Override
        public boolean value() {
            return true;
        }

        public String toString() {
            return "Boolean true";
        }
    };
    public static final DtBoolean FALSE = new DtBoolean(){

        @Override
        public DataType type() {
            return DataType.BOOLEAN;
        }

        @Override
        public boolean value() {
            return false;
        }

        public String toString() {
            return "Boolean false";
        }
    };
    protected final boolean m_Value;

    public static DtBoolean valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static DtBoolean valueOf(Boolean value) {
        return Boolean.TRUE.equals(value) ? TRUE : FALSE;
    }

    public static DtBoolean valueOf(String str) throws DataTypeCastExecption {
        if ("true".equalsIgnoreCase(str)) {
            return TRUE;
        }
        if ("false".equalsIgnoreCase(str)) {
            return FALSE;
        }
        throw new DataTypeCastExecption("\u8f6c\u4e3a[" + (Object)((Object)DataType.BOOLEAN) + "]\u7c7b\u578b\u5931\u8d25\uff0cvalue:" + StringUtil.limit((String)str, (int)100));
    }

    public SimpleDtBoolean(boolean value) {
        this.m_Value = value;
    }

    @Override
    public DataType type() {
        return DataType.BOOLEAN;
    }

    @Override
    public boolean value() {
        return this.m_Value;
    }

    public String toString() {
        return String.valueOf(this.type().toString()) + ' ' + this.m_Value;
    }
}

