/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.datatype;

import cn.weforward.common.util.ListUtil;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.support.datatype.AbstractDtList;
import cn.weforward.protocol.support.datatype.SimpleDtBoolean;
import cn.weforward.protocol.support.datatype.SimpleDtDate;
import cn.weforward.protocol.support.datatype.SimpleDtNumber;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class SimpleDtList
extends AbstractDtList
implements DtList,
Iterable<DtBase> {
    protected final List<DtBase> m_Items;
    static final SimpleDtList EMPTY = new SimpleDtList(Collections.emptyList());

    public SimpleDtList() {
        this(10);
    }

    public SimpleDtList(int initialCapacity) {
        this(new ArrayList<DtBase>(initialCapacity));
    }

    protected SimpleDtList(List<DtBase> list) {
        this.m_Items = list;
    }

    public static SimpleDtList valueOf(List<DtBase> list) {
        if (ListUtil.isEmpty(list)) {
            return EMPTY;
        }
        return new SimpleDtList(new ArrayList<DtBase>(list));
    }

    public static SimpleDtList stringOf(Iterable<String> it) {
        int size = SimpleDtList.getSize(it);
        if (size == 0) {
            return EMPTY;
        }
        Iterator<String> iterator = it.iterator();
        SimpleDtList dtList = new SimpleDtList(size);
        while (iterator.hasNext()) {
            dtList.add(iterator.next());
        }
        return dtList;
    }

    static int getSize(Iterable<?> it) {
        if (it == null) {
            return 0;
        }
        if (it instanceof Collection) {
            return ((Collection)it).size();
        }
        if (!it.iterator().hasNext()) {
            return 0;
        }
        return 10;
    }

    public static SimpleDtList dateOf(Iterable<Date> it) {
        int size = SimpleDtList.getSize(it);
        if (size == 0) {
            return EMPTY;
        }
        Iterator<Date> iterator = it.iterator();
        SimpleDtList dtList = new SimpleDtList(size);
        while (iterator.hasNext()) {
            dtList.add(iterator.next());
        }
        return dtList;
    }

    public static SimpleDtList numberOf(Iterable<? extends Number> it) {
        int size = SimpleDtList.getSize(it);
        if (size == 0) {
            return EMPTY;
        }
        Iterator<? extends Number> iterator = it.iterator();
        SimpleDtList dtList = new SimpleDtList(size);
        while (iterator.hasNext()) {
            dtList.add(iterator.next());
        }
        return dtList;
    }

    public static SimpleDtList booleanOf(Iterable<Boolean> it) {
        int size = SimpleDtList.getSize(it);
        if (size == 0) {
            return EMPTY;
        }
        Iterator<Boolean> iterator = it.iterator();
        SimpleDtList dtList = new SimpleDtList(size);
        while (iterator.hasNext()) {
            dtList.add(iterator.next());
        }
        return dtList;
    }

    public static SimpleDtList empty() {
        return EMPTY;
    }

    public static <E> DtList toDtList(Iterable<? extends E> list, int size, ObjectMapper<E> mapper) {
        if (list == null) {
            return null;
        }
        if (size == 0) {
            return DtList.EMPTY;
        }
        SimpleDtList sl = new SimpleDtList(size < 0 ? 10 : size);
        for (E obj : list) {
            sl.addItem(mapper.toDtObject(obj));
        }
        if (sl.size() == 0) {
            return DtList.EMPTY;
        }
        return sl;
    }

    public static <E> DtList toDtList(List<? extends E> list, ObjectMapper<E> mapper) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return EMPTY;
        }
        return SimpleDtList.toDtList(list, list.size(), mapper);
    }

    public static <E> List<E> fromDtList(DtList list, ObjectMapper<E> mapper) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<E> result = new ArrayList<E>(list.size());
        Enumeration<DtBase> objs = list.items();
        while (objs.hasMoreElements()) {
            DtBase obj = objs.nextElement();
            result.add(mapper.fromDtObject((DtObject)obj));
        }
        return result;
    }

    @Override
    public int size() {
        return this.m_Items.size();
    }

    @Override
    protected DtBase getItemInner(int index) {
        return this.m_Items.get(index);
    }

    @Override
    public Iterator<DtBase> iterator() {
        return this.m_Items.iterator();
    }

    @Override
    public Enumeration<DtBase> items() {
        return Collections.enumeration(this.m_Items);
    }

    public void addItem(DtBase item) {
        this.m_Items.add(item);
    }

    public void add(int value) {
        this.addItem(SimpleDtNumber.valueOf(value));
    }

    public void add(long value) {
        this.addItem(SimpleDtNumber.valueOf(value));
    }

    public void add(double value) {
        this.addItem(SimpleDtNumber.valueOf(value));
    }

    public void add(Number value) {
        this.addItem(SimpleDtNumber.valueOf(value));
    }

    public void add(String value) {
        this.addItem(SimpleDtString.valueOf(value));
    }

    public void add(Date value) {
        this.addItem(SimpleDtDate.valueOf(value));
    }

    public void add(boolean value) {
        this.addItem(SimpleDtBoolean.valueOf(value));
    }

    public DtBase removeItem(int index) {
        return this.m_Items.remove(index);
    }

    public String toString() {
        return String.valueOf(this.type().toString()) + ' ' + this.m_Items;
    }
}

