/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.datatype;

import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.datatype.DataType;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.exception.DataTypeCastExecption;

public class SimpleDtNumber
implements DtNumber {
    public static final SimpleDtNumber ZERO = new SimpleDtNumber(0);
    public static final SimpleDtNumber ONE = new SimpleDtNumber(1);
    public static final SimpleDtNumber TWO = new SimpleDtNumber(2);
    protected static final int MARK_INT = 1;
    protected static final int MARK_LONG = 2;
    protected static final int MARK_DOUBLE = 4;
    protected final int m_IntValue;
    protected final long m_LongValue;
    protected final double m_DoubleValue;
    protected final int m_Marks;

    public SimpleDtNumber(int value) {
        this.m_IntValue = value;
        this.m_LongValue = 0L;
        this.m_DoubleValue = 0.0;
        this.m_Marks = 1;
    }

    public SimpleDtNumber(long value) {
        this.m_IntValue = 0;
        this.m_LongValue = value;
        this.m_DoubleValue = 0.0;
        this.m_Marks = 2;
    }

    public SimpleDtNumber(double value) {
        this.m_IntValue = 0;
        this.m_LongValue = 0L;
        this.m_DoubleValue = value;
        this.m_Marks = 4;
    }

    public static SimpleDtNumber valueOf(int value) {
        if (value == 0) {
            return ZERO;
        }
        if (1 == value) {
            return ONE;
        }
        if (2 == value) {
            return TWO;
        }
        return new SimpleDtNumber(value);
    }

    public static SimpleDtNumber valueOf(long value) {
        if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
            return SimpleDtNumber.valueOf((int)value);
        }
        return new SimpleDtNumber(value);
    }

    public static SimpleDtNumber valueOf(double value) {
        if (0.0 == value) {
            return ZERO;
        }
        if (1.0 == value) {
            return ONE;
        }
        if (2.0 == value) {
            return TWO;
        }
        return new SimpleDtNumber(value);
    }

    public static SimpleDtNumber valueOf(Number num) {
        if (Double.class.isInstance(num) || Float.class.isInstance(num)) {
            return SimpleDtNumber.valueOf(num.doubleValue());
        }
        if (Long.class.isInstance(num)) {
            return SimpleDtNumber.valueOf(num.longValue());
        }
        return SimpleDtNumber.valueOf(num.intValue());
    }

    public static SimpleDtNumber valueOf(String str) throws DataTypeCastExecption {
        Number num;
        if ("0".equals(str)) {
            return ZERO;
        }
        if ("1".equals(str)) {
            return ONE;
        }
        if ("2".equals(str)) {
            return TWO;
        }
        try {
            num = -1 != str.indexOf(46) ? (Number)Double.valueOf(str) : (Number)Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new DataTypeCastExecption("\u8f6c\u4e3a[" + (Object)((Object)DataType.NUMBER) + "]\u7c7b\u578b\u5931\u8d25\uff0cvalue:" + StringUtil.limit((String)str, (int)100));
        }
        return SimpleDtNumber.valueOf(num);
    }

    @Override
    public DataType type() {
        return DataType.NUMBER;
    }

    @Override
    public int valueInt() {
        if (this.isInt()) {
            return this.m_IntValue;
        }
        if (this.isLong()) {
            return (int)this.m_LongValue;
        }
        return (int)this.m_DoubleValue;
    }

    @Override
    public long valueLong() {
        if (this.isInt()) {
            return this.m_IntValue;
        }
        if (this.isLong()) {
            return this.m_LongValue;
        }
        return (long)this.m_DoubleValue;
    }

    @Override
    public double valueDouble() {
        if (this.isInt()) {
            return this.m_IntValue;
        }
        if (this.isLong()) {
            return this.m_LongValue;
        }
        return this.m_DoubleValue;
    }

    @Override
    public Number valueNumber() {
        if (this.isInt()) {
            return this.m_IntValue;
        }
        if (this.isLong()) {
            return this.m_LongValue;
        }
        return this.m_DoubleValue;
    }

    protected boolean isMark(int mark) {
        return mark == (mark & this.m_Marks);
    }

    public static int getInt(DtNumber number, int defaultValue) {
        return number == null ? defaultValue : number.valueInt();
    }

    public static long getLong(DtNumber number, long defaultValue) {
        return number == null ? defaultValue : number.valueLong();
    }

    public static double getInt(DtNumber number, double defaultValue) {
        return number == null ? defaultValue : number.valueDouble();
    }

    @Override
    public boolean isInt() {
        return this.isMark(1);
    }

    @Override
    public boolean isLong() {
        return this.isMark(2);
    }

    @Override
    public boolean isDouble() {
        return this.isMark(4);
    }

    public String toString() {
        StringBuilder sb = StringBuilderPool._128.poll();
        try {
            sb.append(this.type().toString()).append(' ');
            if (this.isInt()) {
                sb.append("int ").append(this.valueInt());
            } else if (this.isLong()) {
                sb.append("long ").append(this.valueLong());
            } else {
                sb.append("double ").append(this.valueDouble());
            }
            String string = sb.toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(sb);
        }
    }
}

