/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.datatype;

import cn.weforward.common.KvPair;
import cn.weforward.common.util.SimpleKvPair;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtMapped;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.support.NamingConverter;
import cn.weforward.protocol.support.datatype.AbstractDtObject;
import cn.weforward.protocol.support.datatype.SimpleDtBoolean;
import cn.weforward.protocol.support.datatype.SimpleDtDate;
import cn.weforward.protocol.support.datatype.SimpleDtNumber;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SimpleDtObject
extends AbstractDtObject
implements DtMapped {
    protected Map<String, DtBase> m_Map;
    protected boolean m_SortAttribute;
    protected Comparator<String> m_Comparator;
    static final SimpleDtObject EMPTY = new SimpleDtObject(Collections.emptyMap());

    public SimpleDtObject() {
        this(true);
    }

    public SimpleDtObject(boolean autoNaming) {
        this(autoNaming ? new AutoNamingMap() : new HashMap());
    }

    protected SimpleDtObject(Map<String, DtBase> map) {
        this.m_Map = map;
    }

    public static SimpleDtObject empty() {
        return EMPTY;
    }

    public void setSortAttribute(boolean sort) {
        this.m_SortAttribute = sort;
    }

    public void setAttributeComparator(Comparator<String> comp) {
        this.m_Comparator = comp;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Collection<String> atts = this.m_Map.keySet();
        if (atts.isEmpty()) {
            return Collections.emptyEnumeration();
        }
        if (this.m_Comparator != null) {
            ArrayList<String> list = new ArrayList<String>(atts);
            Collections.sort(list, this.m_Comparator);
            atts = list;
        } else if (this.m_SortAttribute) {
            ArrayList<String> list = new ArrayList<String>(atts);
            Collections.sort(list);
            atts = list;
        }
        return Collections.enumeration(atts);
    }

    @Override
    protected DtBase getAttributeInner(String name) {
        return this.m_Map.get(name);
    }

    @Override
    public Enumeration<KvPair<String, DtBase>> getAttributes() {
        if (this.m_Comparator != null) {
            return super.getAttributes();
        }
        if (this.m_Map.isEmpty()) {
            return Collections.emptyEnumeration();
        }
        final Iterator<Map.Entry<String, DtBase>> it = this.m_Map.entrySet().iterator();
        return new Enumeration<KvPair<String, DtBase>>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public KvPair<String, DtBase> nextElement() {
                Map.Entry entry = (Map.Entry)it.next();
                return SimpleKvPair.valueOf((Object)((String)entry.getKey()), (Object)((DtBase)entry.getValue()));
            }
        };
    }

    @Override
    public Iterator<KvPair<String, DtBase>> iterator() {
        final Iterator<Map.Entry<String, DtBase>> it = this.m_Map.entrySet().iterator();
        return new Iterator<KvPair<String, DtBase>>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public KvPair<String, DtBase> next() {
                Map.Entry entry = (Map.Entry)it.next();
                return SimpleKvPair.valueOf((Object)((String)entry.getKey()), (Object)((DtBase)entry.getValue()));
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }
        };
    }

    @Override
    public int getAttributeSize() {
        return this.m_Map.size();
    }

    public void putAll(DtObject obj) {
        if (obj == null) {
            return;
        }
        Enumeration<KvPair<String, DtBase>> dtObjAtts = obj.getAttributes();
        while (dtObjAtts.hasMoreElements()) {
            KvPair<String, DtBase> att = dtObjAtts.nextElement();
            if (att.getValue() == null) continue;
            this.put((String)att.getKey(), (DtBase)att.getValue());
        }
    }

    @Override
    public void put(String name, DtBase attribute) {
        this.m_Map.put(name, attribute);
    }

    @Override
    public DtObject toDtObject() {
        return this;
    }

    public void put(String name, int value) {
        this.put(name, SimpleDtNumber.valueOf(value));
    }

    public void put(String name, long value) {
        this.put(name, SimpleDtNumber.valueOf(value));
    }

    public void put(String name, double value) {
        this.put(name, SimpleDtNumber.valueOf(value));
    }

    public void put(String name, String value) {
        this.put(name, SimpleDtString.valueOf(value));
    }

    public void put(String name, Date value) {
        this.put(name, SimpleDtDate.valueOf(value));
    }

    public void put(String name, boolean value) {
        this.put(name, SimpleDtBoolean.valueOf(value));
    }

    public DtBase remove(String name) {
        return this.m_Map.remove(name);
    }

    public String toString() {
        return String.valueOf(this.type().toString()) + ' ' + this.m_Map;
    }

    static class AutoNamingMap
    extends HashMap<String, DtBase> {
        private static final long serialVersionUID = 1L;

        AutoNamingMap() {
        }

        @Override
        public DtBase put(String key, DtBase value) {
            return super.put(NamingConverter.camelToWf(key), value);
        }

        @Override
        public DtBase remove(Object key) {
            return (DtBase)super.remove(NamingConverter.camelToWf((String)key));
        }

        @Override
        public DtBase get(Object key) {
            return (DtBase)super.get(NamingConverter.camelToWf((String)key));
        }
    }
}

