/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.doc;

import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.doc.DocAttribute;
import cn.weforward.protocol.doc.DocObject;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.doc.DocObjectVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;

public class DocAttributeVo
implements DocAttribute,
Comparable<DocAttributeVo> {
    @Resource
    public String name;
    @Resource
    public String type;
    @Resource
    public String component;
    @Resource
    public DocObjectVo detail;
    @Resource
    public String description;
    @Resource
    public String example;
    @Resource
    public int marks;
    public int index;
    public static final ObjectMapper<DocAttributeVo> MAPPER = new ObjectMapper<DocAttributeVo>(){

        @Override
        public String getName() {
            return DocAttributeVo.class.getSimpleName();
        }

        @Override
        public DtObject toDtObject(DocAttributeVo att) throws ObjectMappingException {
            if (att == null) {
                return null;
            }
            SimpleDtObject obj = new SimpleDtObject();
            obj.put("name", att.name);
            obj.put("type", att.type);
            obj.put("component", att.component);
            obj.put("detail", DocObjectVo.MAPPER.toDtObject(att.detail));
            obj.put("description", att.description);
            obj.put("marks", att.marks);
            obj.put("example", att.example);
            return obj;
        }

        @Override
        public DocAttributeVo fromDtObject(DtObject hyObject) throws ObjectMappingException {
            DtString example;
            DtNumber marks;
            DtString description;
            DtObject detail;
            DtString component;
            DtString type;
            if (hyObject == null) {
                return null;
            }
            DocAttributeVo att = new DocAttributeVo();
            DtString name = hyObject.getString("name");
            if (name != null) {
                att.name = name.value();
            }
            if ((type = hyObject.getString("type")) != null) {
                att.type = type.value();
            }
            if ((component = hyObject.getString("component")) != null) {
                att.component = component.value();
            }
            if ((detail = hyObject.getObject("detail")) != null) {
                att.detail = DocObjectVo.MAPPER.fromDtObject(detail);
            }
            if ((description = hyObject.getString("description")) != null) {
                att.description = description.value();
            }
            if ((marks = hyObject.getNumber("marks")) != null) {
                att.marks = marks.valueInt();
            }
            if ((example = hyObject.getString("example")) != null) {
                att.example = example.value();
            }
            return att;
        }
    };

    public DocAttributeVo() {
    }

    public DocAttributeVo(DocAttribute att) {
        this.name = att.getName();
        this.type = att.getType();
        this.component = att.getComponent();
        this.detail = DocObjectVo.valueOf(att.getDetail());
        this.description = att.getDescription();
        this.example = att.getExample();
        this.marks = att.getMarks();
    }

    public static DocAttributeVo valueOf(DocAttribute att) {
        if (att == null) {
            return null;
        }
        if (att instanceof DocAttributeVo) {
            return (DocAttributeVo)att;
        }
        return new DocAttributeVo(att);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getExample() {
        return this.example;
    }

    @Override
    public int getMarks() {
        return this.marks;
    }

    @Override
    public boolean isMark(int mark) {
        return mark == (mark & this.marks);
    }

    public static List<DocAttributeVo> toVoList(List<DocAttribute> list) {
        if (list == null || list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DocAttributeVo> vos = new ArrayList<DocAttributeVo>(list.size());
        for (DocAttribute att : list) {
            vos.add(DocAttributeVo.valueOf(att));
        }
        return vos;
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    @Override
    public DocObject getDetail() {
        return this.detail;
    }

    @Override
    public int compareTo(DocAttributeVo o) {
        int v2;
        int v1 = this.index == 0 ? Integer.MAX_VALUE : this.index;
        int v = v1 - (v2 = o.index == 0 ? Integer.MAX_VALUE : o.index);
        if (v == 0) {
            String n1 = StringUtil.toString((Object)this.name);
            String n2 = StringUtil.toString((Object)o.name);
            return n1.compareTo(n2);
        }
        return v;
    }
}

