/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.doc;

import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.doc.DocAttribute;
import cn.weforward.protocol.doc.DocMethod;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.support.datatype.FriendlyList;
import cn.weforward.protocol.support.datatype.SimpleDtList;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.doc.DocAttributeVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;

public class DocMethodVo
implements DocMethod,
Comparable<DocMethodVo> {
    @Resource
    public String name;
    @Resource
    public String title;
    @Resource
    public String description;
    @Resource
    public List<DocAttributeVo> params;
    @Resource
    public List<DocAttributeVo> returns;
    public int index;
    @Resource
    public List<String> accessKinds;
    @Resource
    public String docAccessLevel;
    public static final ObjectMapper<DocMethodVo> MAPPER = new ObjectMapper<DocMethodVo>(){

        @Override
        public DtObject toDtObject(DocMethodVo method) throws ObjectMappingException {
            if (method == null) {
                return null;
            }
            SimpleDtObject obj = new SimpleDtObject();
            obj.put("name", method.name);
            obj.put("title", method.title);
            obj.put("description", method.description);
            obj.put("params", SimpleDtList.toDtList(method.params, DocAttributeVo.MAPPER));
            obj.put("returns", SimpleDtList.toDtList(method.returns, DocAttributeVo.MAPPER));
            obj.put("access_kinds", SimpleDtList.stringOf(method.accessKinds));
            obj.put("doc_access_level", method.docAccessLevel);
            return obj;
        }

        @Override
        public String getName() {
            return DocMethodVo.class.getSimpleName();
        }

        @Override
        public DocMethodVo fromDtObject(DtObject dtObject) throws ObjectMappingException {
            DtString dal;
            DtList accessKinds;
            DtList returns;
            DtList params;
            DtString description;
            DtString title;
            if (dtObject == null) {
                return null;
            }
            DocMethodVo method = new DocMethodVo();
            DtString name = dtObject.getString("name");
            if (name != null) {
                method.name = name.value();
            }
            if ((title = dtObject.getString("title")) != null) {
                method.title = title.value();
            }
            if ((description = dtObject.getString("description")) != null) {
                method.description = description.value();
            }
            if ((params = dtObject.getList("params")) != null) {
                method.params = FriendlyList.toList(params, DocAttributeVo.MAPPER);
            }
            if ((returns = dtObject.getList("returns")) != null) {
                method.returns = FriendlyList.toList(returns, DocAttributeVo.MAPPER);
            }
            if ((accessKinds = dtObject.getList("access_kinds")) != null) {
                method.accessKinds = FriendlyList.toStringList(accessKinds);
            }
            if ((dal = dtObject.getString("doc_access_level")) != null) {
                method.docAccessLevel = dal.value();
            }
            return method;
        }
    };

    public DocMethodVo() {
    }

    public DocMethodVo(DocMethod method) {
        this.name = method.getName();
        this.title = method.getTitle();
        this.description = method.getDescription();
        this.params = DocAttributeVo.toVoList(method.getParams());
        this.returns = DocAttributeVo.toVoList(method.getReturns());
        this.accessKinds = method.getAccessKinds();
        this.docAccessLevel = method.getDocAccessLevel();
    }

    public static DocMethodVo valueOf(DocMethod method) {
        if (method == null) {
            return null;
        }
        if (method instanceof DocMethodVo) {
            return (DocMethodVo)method;
        }
        return new DocMethodVo(method);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<DocAttribute> getParams() {
        return this.params;
    }

    @Override
    public List<DocAttribute> getReturns() {
        return this.returns;
    }

    public static List<DocMethodVo> toVoList(List<DocMethod> list) {
        if (list == null || list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DocMethodVo> vos = new ArrayList<DocMethodVo>(list.size());
        for (DocMethod m : list) {
            vos.add(DocMethodVo.valueOf(m));
        }
        return vos;
    }

    @Override
    public int compareTo(DocMethodVo o) {
        int v2;
        int v1 = this.index == 0 ? Integer.MAX_VALUE : this.index;
        int v = v1 - (v2 = o.index == 0 ? Integer.MAX_VALUE : o.index);
        if (v == 0) {
            String n1 = StringUtil.toString((Object)this.name);
            String n2 = StringUtil.toString((Object)o.name);
            return this.compareTo(n1, n2);
        }
        return v;
    }

    public int compareTo(String n1, String n2) {
        String[] arr2;
        String[] arr1 = n1.split("\\/");
        int goupsoff = arr1.length - (arr2 = n2.split("\\/")).length;
        if (goupsoff == 0) {
            int i = 0;
            while (i < arr1.length) {
                int c = arr1[i].compareTo(arr2[i]);
                if (c != 0) {
                    return c;
                }
                ++i;
            }
            return 0;
        }
        return goupsoff;
    }

    @Override
    public List<String> getAccessKinds() {
        return this.accessKinds;
    }

    @Override
    public String getDocAccessLevel() {
        return this.docAccessLevel;
    }
}

