/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.doc;

import cn.weforward.protocol.datatype.DtDate;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.doc.DocModify;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

public class DocModifyVo
implements DocModify {
    @Resource
    public String author;
    @Resource
    public Date date;
    @Resource
    public String content;
    public static final ObjectMapper<DocModifyVo> MAPPER = new ObjectMapper<DocModifyVo>(){

        @Override
        public String getName() {
            return ObjectMapper.class.getSimpleName();
        }

        @Override
        public DtObject toDtObject(DocModifyVo modify) throws ObjectMappingException {
            if (modify == null) {
                return null;
            }
            SimpleDtObject obj = new SimpleDtObject();
            obj.put("author", modify.author);
            obj.put("date", modify.date);
            obj.put("content", modify.content);
            return obj;
        }

        @Override
        public DocModifyVo fromDtObject(DtObject hyObject) throws ObjectMappingException {
            DtString content;
            DtDate date;
            if (hyObject == null) {
                return null;
            }
            DocModifyVo modify = new DocModifyVo();
            DtString author = hyObject.getString("author");
            if (author != null) {
                modify.author = author.value();
            }
            if ((date = hyObject.getDate("date")) != null) {
                modify.date = date.valueDate();
            }
            if ((content = hyObject.getString("content")) != null) {
                modify.content = content.value();
            }
            return modify;
        }
    };

    public DocModifyVo() {
    }

    public DocModifyVo(DocModify modify) {
        this.author = modify.getAuthor();
        this.date = modify.getDate();
        this.content = modify.getContent();
    }

    public static DocModifyVo valueOf(DocModify modify) {
        if (modify == null) {
            return null;
        }
        if (modify instanceof DocModifyVo) {
            return (DocModifyVo)modify;
        }
        return new DocModifyVo(modify);
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public static List<DocModifyVo> toVoList(List<DocModify> list) {
        if (list == null || list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DocModifyVo> vos = new ArrayList<DocModifyVo>(list.size());
        for (DocModify m : list) {
            vos.add(DocModifyVo.valueOf(m));
        }
        return vos;
    }
}

