/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.doc;

import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.datatype.DataType;
import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.doc.DocAttribute;
import cn.weforward.protocol.doc.DocObject;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.support.datatype.SimpleDtList;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.doc.DocAttributeVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;

public class DocObjectVo
implements DocObject,
Comparable<DocObjectVo> {
    @Resource
    public String name;
    @Resource
    public String description;
    @Resource
    public List<DocAttributeVo> attributes;
    public int index;
    public static final ObjectMapper<DocObjectVo> MAPPER = new ObjectMapper<DocObjectVo>(){

        @Override
        public String getName() {
            return DocObjectVo.class.getSimpleName();
        }

        @Override
        public DtObject toDtObject(DocObjectVo object) throws ObjectMappingException {
            if (object == null) {
                return null;
            }
            SimpleDtObject obj = new SimpleDtObject();
            obj.put("name", object.name);
            obj.put("description", object.description);
            obj.put("attributes", SimpleDtList.toDtList(object.attributes, DocAttributeVo.MAPPER));
            return obj;
        }

        @Override
        public DocObjectVo fromDtObject(DtObject hyObject) throws ObjectMappingException {
            DtList attributes;
            DtString description;
            if (hyObject == null) {
                return null;
            }
            DocObjectVo object = new DocObjectVo();
            DtString name = hyObject.getString("name");
            if (name != null) {
                object.name = name.value();
            }
            if ((description = hyObject.getString("description")) != null) {
                object.description = description.value();
            }
            if ((attributes = hyObject.getList("attributes")) != null) {
                object.attributes = SimpleDtList.fromDtList(attributes, DocAttributeVo.MAPPER);
            }
            return object;
        }
    };
    public static final DocObjectVo RESULT_PAGE = new DocObjectVo();

    static {
        DocObjectVo.RESULT_PAGE.name = "ResultPage";
        DocObjectVo.RESULT_PAGE.description = "\u5206\u9875\u6570\u636e\u96c6\u5408";
        ArrayList<DocAttributeVo> atts = new ArrayList<DocAttributeVo>();
        DocAttributeVo count = new DocAttributeVo();
        count.name = "count";
        count.description = "\u603b\u9879\u6570";
        count.type = DataType.NUMBER.value;
        atts.add(count);
        DocAttributeVo page = new DocAttributeVo();
        page.name = "page";
        page.description = "\u5f53\u524d\u9875";
        page.type = DataType.NUMBER.value;
        atts.add(page);
        DocAttributeVo pageCount = new DocAttributeVo();
        pageCount.name = "page_count";
        pageCount.description = "\u603b\u9875\u6570";
        pageCount.type = DataType.NUMBER.value;
        atts.add(pageCount);
        DocAttributeVo pageSize = new DocAttributeVo();
        pageSize.name = "page_size";
        pageSize.description = "\u6bcf\u9875\u9879\u6570";
        pageSize.type = DataType.NUMBER.value;
        atts.add(pageSize);
        DocAttributeVo items = new DocAttributeVo();
        items.name = "items";
        items.description = "\u5f53\u524d\u9875\u5143\u7d20\u5217\u8868";
        items.type = DataType.LIST.value;
        atts.add(items);
        DocObjectVo.RESULT_PAGE.attributes = atts;
    }

    public DocObjectVo() {
    }

    public DocObjectVo(DocObject obj) {
        this.name = obj.getName();
        this.description = obj.getDescription();
        this.attributes = DocAttributeVo.toVoList(obj.getAttributes());
    }

    public static DocObjectVo valueOf(DocObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof DocObjectVo) {
            return (DocObjectVo)obj;
        }
        return new DocObjectVo(obj);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<DocAttribute> getAttributes() {
        return this.attributes;
    }

    public static List<DocObjectVo> toVoList(List<DocObject> list) {
        if (list == null || list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DocObjectVo> vos = new ArrayList<DocObjectVo>(list.size());
        for (DocObject o : list) {
            vos.add(DocObjectVo.valueOf(o));
        }
        return vos;
    }

    @Override
    public int compareTo(DocObjectVo o) {
        int v2;
        int v1 = this.index == 0 ? Integer.MAX_VALUE : this.index;
        int v = v1 - (v2 = o.index == 0 ? Integer.MAX_VALUE : o.index);
        if (v == 0) {
            String n1 = StringUtil.toString((Object)this.name);
            String n2 = StringUtil.toString((Object)o.name);
            return n1.compareTo(n2);
        }
        return v;
    }
}

