/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.doc;

import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.doc.DocSpecialWord;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import cn.weforward.protocol.support.datatype.SimpleDtList;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DocSpecialWordVo
implements DocSpecialWord {
    public String name;
    public String description;
    public ItemVo tableHeader;
    public List<ItemVo> tableItems;
    public static final ObjectMapper<ItemVo> ITEM_MAPPER = new ObjectMapper<ItemVo>(){

        @Override
        public String getName() {
            return ItemVo.class.getSimpleName();
        }

        @Override
        public DtObject toDtObject(ItemVo item) throws ObjectMappingException {
            if (item == null) {
                return null;
            }
            SimpleDtObject obj = new SimpleDtObject();
            obj.put("key", item.key);
            obj.put("value", item.value);
            obj.put("description", item.description);
            return obj;
        }

        @Override
        public ItemVo fromDtObject(DtObject obj) throws ObjectMappingException {
            if (obj == null) {
                return null;
            }
            FriendlyObject fobj = new FriendlyObject(obj);
            ItemVo item = new ItemVo();
            item.key = fobj.getString("key");
            item.value = fobj.getString("value");
            item.description = fobj.getString("description");
            return item;
        }
    };
    public static final ObjectMapper<DocSpecialWordVo> MAPPER = new ObjectMapper<DocSpecialWordVo>(){

        @Override
        public DtObject toDtObject(DocSpecialWordVo word) throws ObjectMappingException {
            if (word == null) {
                return null;
            }
            SimpleDtObject obj = new SimpleDtObject();
            obj.put("name", word.name);
            obj.put("description", word.description);
            obj.put("table_header", ITEM_MAPPER.toDtObject(word.tableHeader));
            obj.put("table_items", SimpleDtList.toDtList(word.tableItems, ITEM_MAPPER));
            return obj;
        }

        @Override
        public String getName() {
            return DocSpecialWordVo.class.getSimpleName();
        }

        @Override
        public DocSpecialWordVo fromDtObject(DtObject obj) throws ObjectMappingException {
            if (obj == null) {
                return null;
            }
            FriendlyObject fobj = new FriendlyObject(obj);
            DocSpecialWordVo word = new DocSpecialWordVo();
            word.name = fobj.getString("name");
            word.description = fobj.getString("description");
            word.tableHeader = fobj.getObject("table_header", ITEM_MAPPER);
            word.tableItems = fobj.getList("table_items", ITEM_MAPPER);
            return word;
        }
    };

    public static List<DocSpecialWordVo> toVoList(List<DocSpecialWord> list) {
        if (list == null || list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DocSpecialWordVo> vos = new ArrayList<DocSpecialWordVo>(list.size());
        for (DocSpecialWord o : list) {
            vos.add(DocSpecialWordVo.valueOf(o));
        }
        return vos;
    }

    public DocSpecialWordVo() {
    }

    public DocSpecialWordVo(DocSpecialWord word) {
        this.name = word.getName();
        this.description = word.getDescription();
        this.tableHeader = ItemVo.valueOf(word.getTableHeader());
        this.tableItems = ItemVo.toVoList(word.getTableItems());
    }

    public static DocSpecialWordVo valueOf(DocSpecialWord word) {
        if (word == null) {
            return null;
        }
        if (word instanceof DocSpecialWordVo) {
            return (DocSpecialWordVo)word;
        }
        return new DocSpecialWordVo(word);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DocSpecialWord.Item getTableHeader() {
        return this.tableHeader;
    }

    @Override
    public List<DocSpecialWord.Item> getTableItems() {
        return this.tableItems;
    }

    public static class ItemVo
    implements DocSpecialWord.Item {
        public String key;
        public String value;
        public String description;

        public ItemVo() {
        }

        public ItemVo(DocSpecialWord.Item item) {
            this.key = item.getKey();
            this.value = item.getValue();
            this.description = item.getDescription();
        }

        public static ItemVo valueOf(DocSpecialWord.Item item) {
            if (item == null) {
                return null;
            }
            if (item instanceof ItemVo) {
                return (ItemVo)item;
            }
            return new ItemVo(item);
        }

        public static List<ItemVo> toVoList(List<DocSpecialWord.Item> list) {
            if (list == null || list.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<ItemVo> vos = new ArrayList<ItemVo>(list.size());
            for (DocSpecialWord.Item o : list) {
                vos.add(ItemVo.valueOf(o));
            }
            return vos;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

