/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.doc;

import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.doc.DocStatusCode;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;

public class DocStatusCodeVo
implements DocStatusCode {
    @Resource
    public int code;
    @Resource
    public String message;
    public static final ObjectMapper<DocStatusCodeVo> MAPPER = new ObjectMapper<DocStatusCodeVo>(){

        @Override
        public DtObject toDtObject(DocStatusCodeVo code) throws ObjectMappingException {
            if (code == null) {
                return null;
            }
            SimpleDtObject obj = new SimpleDtObject();
            obj.put("code", code.code);
            obj.put("message", code.message);
            return obj;
        }

        @Override
        public String getName() {
            return DocStatusCodeVo.class.getSimpleName();
        }

        @Override
        public DocStatusCodeVo fromDtObject(DtObject hyObject) throws ObjectMappingException {
            DtString message;
            if (hyObject == null) {
                return null;
            }
            DocStatusCodeVo sc = new DocStatusCodeVo();
            DtNumber code = hyObject.getNumber("code");
            if (code != null) {
                sc.code = code.valueInt();
            }
            if ((message = hyObject.getString("message")) != null) {
                sc.message = message.value();
            }
            return sc;
        }
    };

    public DocStatusCodeVo() {
    }

    public DocStatusCodeVo(DocStatusCode code) {
        this.code = code.getCode();
        this.message = code.getMessage();
    }

    public static DocStatusCodeVo valueOf(DocStatusCode code) {
        if (code == null) {
            return null;
        }
        if (code instanceof DocStatusCodeVo) {
            return (DocStatusCodeVo)code;
        }
        return new DocStatusCodeVo(code);
    }

    public static List<DocStatusCodeVo> toVoList(List<DocStatusCode> list) {
        if (list == null || list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DocStatusCodeVo> vos = new ArrayList<DocStatusCodeVo>(list.size());
        for (DocStatusCode code : list) {
            vos.add(DocStatusCodeVo.valueOf(code));
        }
        return vos;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

