/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.doc;

import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.doc.DocMethod;
import cn.weforward.protocol.doc.DocModify;
import cn.weforward.protocol.doc.DocObject;
import cn.weforward.protocol.doc.DocSpecialWord;
import cn.weforward.protocol.doc.DocStatusCode;
import cn.weforward.protocol.doc.ServiceDocument;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.support.datatype.SimpleDtList;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.doc.DocMethodVo;
import cn.weforward.protocol.support.doc.DocModifyVo;
import cn.weforward.protocol.support.doc.DocObjectVo;
import cn.weforward.protocol.support.doc.DocSpecialWordVo;
import cn.weforward.protocol.support.doc.DocStatusCodeVo;
import java.util.List;
import javax.annotation.Resource;

public class ServiceDocumentVo
implements ServiceDocument {
    @Resource
    public String name;
    @Resource
    public String version;
    @Resource
    public String description;
    @Resource
    public List<DocModifyVo> modifies;
    @Resource
    public List<DocMethodVo> methods;
    @Resource
    public List<DocObjectVo> objects;
    @Resource
    public List<DocStatusCodeVo> statusCodes;
    @Resource
    public List<DocSpecialWordVo> specialWords;
    @Resource
    public int marks;
    public static final ObjectMapper<ServiceDocumentVo> MAPPER = new ObjectMapper<ServiceDocumentVo>(){

        @Override
        public DtObject toDtObject(ServiceDocumentVo doc) throws ObjectMappingException {
            if (doc == null) {
                return null;
            }
            SimpleDtObject obj = new SimpleDtObject();
            obj.put("name", doc.name);
            obj.put("version", doc.version);
            obj.put("description", doc.description);
            obj.put("modifies", SimpleDtList.toDtList(doc.modifies, DocModifyVo.MAPPER));
            obj.put("methods", SimpleDtList.toDtList(doc.methods, DocMethodVo.MAPPER));
            obj.put("objects", SimpleDtList.toDtList(doc.objects, DocObjectVo.MAPPER));
            obj.put("status_codes", SimpleDtList.toDtList(doc.statusCodes, DocStatusCodeVo.MAPPER));
            obj.put("special_words", SimpleDtList.toDtList(doc.specialWords, DocSpecialWordVo.MAPPER));
            obj.put("marks", doc.marks);
            return obj;
        }

        @Override
        public String getName() {
            return ServiceDocumentVo.class.getSimpleName();
        }

        @Override
        public ServiceDocumentVo fromDtObject(DtObject hyObject) throws ObjectMappingException {
            DtNumber marks;
            DtList specialWords;
            DtList statusCodes;
            DtList objects;
            DtList methods;
            DtList modifies;
            DtString description;
            DtString version;
            if (hyObject == null) {
                return null;
            }
            ServiceDocumentVo doc = new ServiceDocumentVo();
            DtString name = hyObject.getString("name");
            if (name != null) {
                doc.name = name.value();
            }
            if ((version = hyObject.getString("version")) != null) {
                doc.version = version.value();
            }
            if ((description = hyObject.getString("description")) != null) {
                doc.description = description.value();
            }
            if ((modifies = hyObject.getList("modifies")) != null) {
                doc.modifies = SimpleDtList.fromDtList(modifies, DocModifyVo.MAPPER);
            }
            if ((methods = hyObject.getList("methods")) != null) {
                doc.methods = SimpleDtList.fromDtList(methods, DocMethodVo.MAPPER);
            }
            if ((objects = hyObject.getList("objects")) != null) {
                doc.objects = SimpleDtList.fromDtList(objects, DocObjectVo.MAPPER);
            }
            if ((statusCodes = hyObject.getList("status_codes")) != null) {
                doc.statusCodes = SimpleDtList.fromDtList(statusCodes, DocStatusCodeVo.MAPPER);
            }
            if ((specialWords = hyObject.getList("special_words")) != null) {
                doc.specialWords = SimpleDtList.fromDtList(specialWords, DocSpecialWordVo.MAPPER);
            }
            if ((marks = hyObject.getNumber("marks")) != null) {
                doc.marks = marks.valueInt();
            }
            return doc;
        }
    };

    public ServiceDocumentVo() {
    }

    public ServiceDocumentVo(ServiceDocument doc) {
        this.name = doc.getName();
        this.version = doc.getVersion();
        this.description = doc.getDescription();
        this.modifies = DocModifyVo.toVoList(doc.getModifies());
        this.methods = DocMethodVo.toVoList(doc.getMethods());
        this.objects = DocObjectVo.toVoList(doc.getObjects());
        this.statusCodes = DocStatusCodeVo.toVoList(doc.getStatusCodes());
        this.specialWords = DocSpecialWordVo.toVoList(doc.getSpecialWords());
        this.marks = doc.getMarks();
    }

    public static ServiceDocumentVo valueOf(ServiceDocument doc) {
        if (doc == null) {
            return null;
        }
        if (doc instanceof ServiceDocumentVo) {
            return (ServiceDocumentVo)doc;
        }
        return new ServiceDocumentVo(doc);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<DocModify> getModifies() {
        return this.modifies;
    }

    @Override
    public List<DocMethod> getMethods() {
        return this.methods;
    }

    @Override
    public List<DocObject> getObjects() {
        return this.objects;
    }

    @Override
    public List<DocStatusCode> getStatusCodes() {
        return this.statusCodes;
    }

    @Override
    public int getMarks() {
        return this.marks;
    }

    @Override
    public boolean isMark(int mark) {
        return mark == (mark & this.marks);
    }

    @Override
    public List<DocSpecialWord> getSpecialWords() {
        return this.specialWords;
    }
}

