/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.topic;

import cn.weforward.common.Nameable;
import cn.weforward.common.crypto.Hex;
import cn.weforward.common.sys.Timestamp;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.AccessLoader;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.client.AioServiceInvoker;
import cn.weforward.protocol.client.netty.NettyAnyServiceInvoker;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.support.SimpleProducer;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicProducer {
    protected static final Logger _Logger = LoggerFactory.getLogger(TopicProducer.class);
    protected static final Timestamp _Timestamp = Timestamp.getInstance((int)Timestamp.POLICY_DEFAULT);
    protected Map<String, String> m_Services;
    protected List<String> m_Groups;
    protected NettyAnyServiceInvoker m_Invoker;
    protected String m_ServerId;

    public TopicProducer(String apiUrl, String accessId, String accessKey) {
        AccessLoader accessLoader = StringUtil.isEmpty((String)accessId) ? AccessLoader.EMPTY : new AccessLoader.Single(accessId, accessKey);
        SimpleProducer producer = new SimpleProducer(accessLoader);
        String[] urls = apiUrl.split(";");
        if (urls != null && urls.length > 0) {
            apiUrl = urls[0];
        }
        this.m_Invoker = new NettyAnyServiceInvoker(apiUrl, producer);
        this.m_Invoker.setAccessId(accessId);
    }

    public String getServerId() {
        return this.m_ServerId;
    }

    public void setServerId(String serverId) {
        this.m_ServerId = serverId;
    }

    public synchronized void setServices(String serviceList) {
        this.m_Services = null;
        if (StringUtil.isEmpty((String)serviceList)) {
            return;
        }
        String[] ss = serviceList.split(";");
        HashMap<String, String> services = new HashMap<String, String>();
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!StringUtil.isEmpty((String)s)) {
                services.put(s, s);
            }
            ++n2;
        }
        this.m_Services = services;
    }

    public void setService(Nameable service) {
        this.addService(service.getName());
    }

    public void setServices(Iterable<Nameable> services) {
        for (Nameable s : services) {
            if (s == null) continue;
            this.addService(s.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addService(String serviceName) {
        if (StringUtil.isEmpty((String)serviceName)) {
            return false;
        }
        TopicProducer topicProducer = this;
        synchronized (topicProducer) {
            block6: {
                if (this.m_Services == null) {
                    this.m_Services = new HashMap<String, String>();
                }
                if (this.m_Services.put(serviceName, serviceName) != null) break block6;
                this.m_Groups = null;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeService(String serviceName) {
        TopicProducer topicProducer = this;
        synchronized (topicProducer) {
            block4: {
                if (this.m_Services == null || this.m_Services.remove(serviceName) == null) break block4;
                this.m_Groups = null;
                return true;
            }
        }
        return false;
    }

    public String publish(String deliver, Listener listener, String topic, String tag, DtBase content) {
        String id;
        List<String> groups = this.getGroups();
        if (groups.isEmpty()) {
            return null;
        }
        NettyAnyServiceInvoker invoker = this.getInvoker();
        long ts = this.nextTimestamp();
        StringBuilder builder = StringBuilderPool._128.poll();
        try {
            Hex.toHex((long)ts, (StringBuilder)builder);
            id = this.getServerId();
            if (!StringUtil.isEmpty((String)id)) {
                builder.append('-').append(id);
            }
            id = builder.toString();
        }
        finally {
            StringBuilderPool._128.offer(builder);
        }
        ts >>>= 8;
        SimpleDtObject params = new SimpleDtObject();
        params.put("id", id);
        params.put("topic", topic);
        params.put("tag", tag);
        if (!StringUtil.isEmpty((String)deliver)) {
            params.put("deliver", deliver);
        }
        if (content != null) {
            params.put("content", content);
        }
        OfferHandler handler = new OfferHandler(id, groups.size(), listener);
        int i = 0;
        while (i < groups.size()) {
            Request req = invoker.createRequest(groups.get(i), "topic", params);
            req.getHeader().setChannel("topic");
            invoker.invoke(req, handler);
            ++i;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getGroups() {
        List<String> groups = this.m_Groups;
        if (groups != null) {
            return groups;
        }
        TopicProducer topicProducer = this;
        synchronized (topicProducer) {
            if (this.m_Services == null || this.m_Services.size() == 0) {
                groups = Collections.emptyList();
            } else {
                groups = new ArrayList<String>(this.m_Services.size() / 2);
                StringBuilder serviceList = new StringBuilder(1024);
                for (Map.Entry<String, String> e : this.m_Services.entrySet()) {
                    String serviceName = e.getKey();
                    if (StringUtil.isEmpty((String)serviceName)) continue;
                    if (serviceName.length() + serviceList.length() > serviceList.capacity()) {
                        groups.add(serviceList.toString());
                        serviceList.setLength(0);
                    }
                    if (serviceList.length() > 0) {
                        serviceList.append(';');
                    }
                    serviceList.append(serviceName);
                }
                if (serviceList.length() > 0) {
                    groups.add(serviceList.toString());
                }
            }
            this.m_Groups = groups;
        }
        return groups;
    }

    protected NettyAnyServiceInvoker getInvoker() {
        return this.m_Invoker;
    }

    protected long nextTimestamp() {
        return _Timestamp.next(0) >>> 8;
    }

    public static interface Listener {
        public void success(String var1);

        public void fail(String var1);

        public void complete(String var1, int var2, int var3);
    }

    static class OfferHandler
    implements AioServiceInvoker.Listener {
        final Listener m_Listener;
        final AtomicInteger m_Tasks;
        final String m_Id;
        volatile int m_Fails;
        volatile int m_Success;

        OfferHandler(String id, int count, Listener listener) {
            this.m_Id = id;
            this.m_Tasks = new AtomicInteger(count);
            this.m_Listener = listener;
        }

        public synchronized boolean await(int timeout) throws InterruptedException {
            if (this.m_Tasks.get() <= 0) {
                return true;
            }
            this.wait(timeout);
            return this.m_Tasks.get() <= 0;
        }

        @Override
        public void success(Request request, Response response) {
            if (response.getResponseCode() != 0) {
                this.fail(request, null);
                _Logger.warn("\u53d1\u5e03\u6d88\u606f\u5931\u8d25:" + this.m_Id + ",servcie:" + request.getHeader().getService() + ",code:" + response.getResponseCode() + ",msg:" + response.getResponseMsg());
                return;
            }
            DtObject result = response.getServiceResult();
            if (result == null) {
                ++this.m_Success;
            } else {
                DtList content = result.getList("content");
                int i = content.size() - 1;
                while (i >= 0) {
                    result = (DtObject)content.getItem(i);
                    DtNumber receives = result.getNumber("receives");
                    if (receives != null && receives.valueInt() < 1) {
                        ++this.m_Fails;
                        _Logger.warn("\u53d1\u5e03\u5931\u8d25:" + this.m_Id + ",servcie:" + SimpleDtString.getString(result.getString("name")) + ",err:" + SimpleDtString.getString(result.getString("err")));
                    } else {
                        ++this.m_Success;
                        if (_Logger.isDebugEnabled()) {
                            _Logger.debug("\u53d1\u5e03\u6210\u529f:" + this.m_Id + ",servcie:" + SimpleDtString.getString(result.getString("name")) + ",count:" + receives.valueInt());
                        }
                    }
                    --i;
                }
            }
            if (this.m_Listener != null) {
                this.m_Listener.success(request.getHeader().getService());
            }
        }

        @Override
        public void fail(Request request, Throwable throwable) {
            ++this.m_Fails;
            if (this.m_Listener != null) {
                this.m_Listener.fail(request.getHeader().getService());
            }
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("\u53d1\u5e03\u6d88\u606f\u5931\u8d25:" + this.m_Id + ",servcie:" + request.getHeader().getService() + ",err:" + (throwable == null ? "" : throwable.getMessage()), throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete(Request request) {
            if (this.m_Tasks.decrementAndGet() <= 0) {
                OfferHandler offerHandler = this;
                synchronized (offerHandler) {
                    this.notifyAll();
                }
                if (this.m_Listener != null) {
                    this.m_Listener.complete(this.m_Id, this.m_Success, this.m_Fails);
                }
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug("\u5b8c\u6210\u53d1\u5e03:" + this.m_Id + ",succ:" + this.m_Success + ",fail:" + this.m_Fails);
                }
            }
        }
    }
}

