/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage.platform;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.xuyanwu.spring.file.storage.FileInfo;
import cn.xuyanwu.spring.file.storage.UploadPretreatment;
import cn.xuyanwu.spring.file.storage.exception.FileStorageRuntimeException;
import cn.xuyanwu.spring.file.storage.platform.FileStorage;
import com.obs.services.ObsClient;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public class HuaweiObsFileStorage
implements FileStorage {
    private String platform;
    private String accessKey;
    private String secretKey;
    private String endPoint;
    private String bucketName;
    private String domain;
    private String basePath;
    private ObsClient client;

    public ObsClient getClient() {
        if (this.client == null) {
            this.client = new ObsClient(this.accessKey, this.secretKey, this.endPoint);
        }
        return this.client;
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.client);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        String newFileKey = this.basePath + pre.getPath() + fileInfo.getFilename();
        fileInfo.setBasePath(this.basePath);
        fileInfo.setUrl(this.domain + newFileKey);
        ObsClient client = this.getClient();
        try (InputStream in = pre.getFileWrapper().getInputStream();){
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(fileInfo.getSize());
            metadata.setContentType(fileInfo.getContentType());
            client.putObject(this.bucketName, newFileKey, in, metadata);
            byte[] thumbnailBytes = pre.getThumbnailBytes();
            if (thumbnailBytes != null) {
                String newThFileKey = this.basePath + fileInfo.getPath() + fileInfo.getThFilename();
                fileInfo.setThUrl(this.domain + newThFileKey);
                ObjectMetadata thMetadata = new ObjectMetadata();
                thMetadata.setContentLength(Long.valueOf(thumbnailBytes.length));
                thMetadata.setContentType(fileInfo.getThContentType());
                client.putObject(this.bucketName, newThFileKey, (InputStream)new ByteArrayInputStream(thumbnailBytes), thMetadata);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            client.deleteObject(this.bucketName, newFileKey);
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a" + this.platform + "\uff0cfilename\uff1a" + fileInfo.getOriginalFilename(), e);
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        ObsClient client = this.getClient();
        if (fileInfo.getThFilename() != null) {
            client.deleteObject(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename());
        }
        client.deleteObject(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
        return true;
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        return this.getClient().doesObjectExist(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        ObsObject object = this.getClient().getObject(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
        try (InputStream in = object.getObjectContent();){
            consumer.accept(in);
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01platform\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        ObsObject object = this.getClient().getObject(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename());
        try (InputStream in = object.getObjectContent();){
            consumer.accept(in);
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setClient(ObsClient client) {
        this.client = client;
    }
}

