/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.DataType;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.RefType;
import com.agentsflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseNode
extends ChainNode {
    protected String description;
    protected List<Parameter> parameters;
    protected List<Parameter> outputDefs;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void addInputParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parameter);
    }

    public List<Parameter> getOutputDefs() {
        return this.outputDefs;
    }

    public void setOutputDefs(List<Parameter> outputDefs) {
        this.outputDefs = outputDefs;
    }

    public void addOutputDef(Parameter parameter) {
        if (this.outputDefs == null) {
            this.outputDefs = new ArrayList<Parameter>();
        }
        this.outputDefs.add(parameter);
    }

    public void addOutputDefs(Collection<Parameter> parameters) {
        if (this.outputDefs == null) {
            this.outputDefs = new ArrayList<Parameter>();
        }
        this.outputDefs.addAll(parameters);
    }

    public Map<String, Object> getChainParameters(Chain chain, List<Parameter> parameters) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                RefType refType = parameter.getRefType();
                Object value = refType == RefType.INPUT ? parameter.getRef() : (refType == RefType.REF ? chain.get(parameter.getRef()) : chain.get(parameter.getName()));
                if (parameter.isRequired() && (value == null || value instanceof String && StringUtil.noText((String)value))) {
                    chain.stopError(this.getName() + " Missing required parameter:" + parameter.getName());
                }
                if (value == null || value instanceof String) {
                    Object object = value = value == null ? "" : ((String)value).trim();
                    if (parameter.getDataType() == DataType.Boolean) {
                        value = "true".equalsIgnoreCase((String)value) || "1".equalsIgnoreCase((String)value);
                    } else if (parameter.getDataType() == DataType.Number) {
                        value = Long.parseLong((String)value);
                    }
                }
                variables.put(parameter.getName(), value);
            }
        }
        return variables;
    }

    public Map<String, Object> getParameters(Chain chain) {
        return this.getChainParameters(chain, this.parameters);
    }
}

