/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.store;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.document.DocumentSplitter;
import com.agentsflex.core.document.id.DocumentIdGenerator;
import com.agentsflex.core.document.id.DocumentIdGeneratorFactory;
import com.agentsflex.core.llm.embedding.EmbeddingModel;
import com.agentsflex.core.store.SearchWrapper;
import com.agentsflex.core.store.StoreOptions;
import com.agentsflex.core.store.StoreResult;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.store.VectorStore;
import java.util.Collection;
import java.util.List;

public abstract class DocumentStore
extends VectorStore<Document> {
    private EmbeddingModel embeddingModel;
    private DocumentSplitter documentSplitter;
    private DocumentIdGenerator documentIdGenerator = DocumentIdGeneratorFactory.getDocumentIdGenerator();

    public EmbeddingModel getEmbeddingModel() {
        return this.embeddingModel;
    }

    public void setEmbeddingModel(EmbeddingModel embeddingModel) {
        this.embeddingModel = embeddingModel;
    }

    public DocumentSplitter getDocumentSplitter() {
        return this.documentSplitter;
    }

    public void setDocumentSplitter(DocumentSplitter documentSplitter) {
        this.documentSplitter = documentSplitter;
    }

    public DocumentIdGenerator getDocumentIdGenerator() {
        return this.documentIdGenerator;
    }

    public void setDocumentIdGenerator(DocumentIdGenerator documentIdGenerator) {
        this.documentIdGenerator = documentIdGenerator;
    }

    @Override
    public StoreResult store(List<Document> documents, StoreOptions options) {
        if (options == null) {
            options = StoreOptions.DEFAULT;
        }
        if (this.documentSplitter != null) {
            documents = this.documentSplitter.splitAll(documents, this.documentIdGenerator);
        } else if (this.documentIdGenerator != null) {
            for (Document document : documents) {
                if (document.getId() != null) continue;
                Object id = this.documentIdGenerator.generateId(document);
                document.setId(id);
            }
        }
        this.embedDocumentsIfNecessary(documents, options);
        return this.storeInternal(documents, options);
    }

    @Override
    public StoreResult delete(Collection<?> ids, StoreOptions options) {
        if (options == null) {
            options = StoreOptions.DEFAULT;
        }
        return this.deleteInternal(ids, options);
    }

    @Override
    public StoreResult update(List<Document> documents, StoreOptions options) {
        if (options == null) {
            options = StoreOptions.DEFAULT;
        }
        this.embedDocumentsIfNecessary(documents, options);
        return this.updateInternal(documents, options);
    }

    @Override
    public List<Document> search(SearchWrapper wrapper, StoreOptions options) {
        VectorData vectorData;
        if (options == null) {
            options = StoreOptions.DEFAULT;
        }
        if (wrapper.getVector() == null && this.embeddingModel != null && wrapper.isWithVector() && (vectorData = this.embeddingModel.embed(Document.of(wrapper.getText()), options.getEmbeddingOptions())) != null) {
            wrapper.setVector(vectorData.getVector());
        }
        return this.searchInternal(wrapper, options);
    }

    protected void embedDocumentsIfNecessary(List<Document> documents, StoreOptions options) {
        if (this.embeddingModel == null) {
            return;
        }
        for (Document document : documents) {
            VectorData vectorData;
            if (document.getVector() != null || (vectorData = this.embeddingModel.embed(document, options.getEmbeddingOptions())) == null) continue;
            document.setVector(vectorData.getVector());
        }
    }

    public abstract StoreResult storeInternal(List<Document> var1, StoreOptions var2);

    public abstract StoreResult deleteInternal(Collection<?> var1, StoreOptions var2);

    public abstract StoreResult updateInternal(List<Document> var1, StoreOptions var2);

    public abstract List<Document> searchInternal(SearchWrapper var1, StoreOptions var2);
}

