/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.store;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.util.Metadata;
import java.util.ArrayList;
import java.util.List;

public class StoreResult
extends Metadata {
    private final boolean success;
    private List<Object> ids;

    public StoreResult(boolean success) {
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<Object> ids() {
        return this.ids;
    }

    public static StoreResult fail() {
        return new StoreResult(false);
    }

    public static StoreResult success() {
        return new StoreResult(true);
    }

    public static StoreResult successWithIds(List<Document> documents) {
        StoreResult result = StoreResult.success();
        result.ids = new ArrayList<Object>(documents.size());
        for (Document document : documents) {
            result.ids.add(document.getId());
        }
        return result;
    }

    public String toString() {
        return "StoreResult{success=" + this.success + ", ids=" + this.ids + '}';
    }
}

