/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.util;

import com.agentsflex.core.util.StringUtil;
import java.util.Map;
import java.util.function.Function;

public class MapUtil {
    private static final boolean IS_JDK8 = 8 == MapUtil.getJvmVersion0();

    private MapUtil() {
    }

    private static String tryTrim(String string) {
        return string != null ? string.trim() : "";
    }

    private static int getJvmVersion0() {
        int jvmVersion = -1;
        try {
            String javaSpecVer = MapUtil.tryTrim(System.getProperty("java.specification.version"));
            if (StringUtil.hasText(javaSpecVer)) {
                if (javaSpecVer.startsWith("1.")) {
                    javaSpecVer = javaSpecVer.substring(2);
                }
                if (javaSpecVer.indexOf(46) == -1) {
                    jvmVersion = Integer.parseInt(javaSpecVer);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (jvmVersion == -1) {
            jvmVersion = 8;
        }
        return jvmVersion;
    }

    public static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<K, V> mappingFunction) {
        V value;
        if (IS_JDK8 && (value = map.get(key)) != null) {
            return value;
        }
        return map.computeIfAbsent(key, mappingFunction);
    }
}

