/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.openai;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.MessageResponse;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.llm.response.FunctionMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.message.FunctionMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.FunctionMessageParser;
import com.agentsflex.core.prompt.FunctionPrompt;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.openai.OpenAiLLmUtil;
import com.agentsflex.llm.openai.OpenAiLlmConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.HashMap;
import java.util.function.Consumer;

public class OpenAiLlm
extends BaseLlm<OpenAiLlmConfig> {
    private final HttpClient httpClient = new HttpClient();
    public AiMessageParser aiMessageParser = OpenAiLLmUtil.getAiMessageParser(false);
    public AiMessageParser streamMessageParser = OpenAiLLmUtil.getAiMessageParser(true);
    public FunctionMessageParser functionMessageParser = OpenAiLLmUtil.getFunctionMessageParser();

    public static OpenAiLlm of(String apiKey) {
        OpenAiLlmConfig config = new OpenAiLlmConfig();
        config.setApiKey(apiKey);
        return new OpenAiLlm(config);
    }

    public static OpenAiLlm of(String apiKey, String endpoint) {
        OpenAiLlmConfig config = new OpenAiLlmConfig();
        config.setApiKey(apiKey);
        config.setEndpoint(endpoint);
        return new OpenAiLlm(config);
    }

    public OpenAiLlm(OpenAiLlmConfig config) {
        super((LlmConfig)config);
    }

    public <R extends MessageResponse<?>> R chat(Prompt<R> prompt, ChatOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((OpenAiLlmConfig)this.getConfig()).getApiKey());
        Consumer headersConfig = ((OpenAiLlmConfig)this.config).getHeadersConfig();
        if (headersConfig != null) {
            headersConfig.accept(headers);
        }
        String payload = OpenAiLLmUtil.promptToPayload(prompt, (OpenAiLlmConfig)this.config, options, false);
        String endpoint = ((OpenAiLlmConfig)this.config).getEndpoint();
        String response = this.httpClient.post(endpoint + "/v1/chat/completions", headers, payload);
        if (StringUtil.noText((String)response)) {
            return null;
        }
        if (((OpenAiLlmConfig)this.config).isDebug()) {
            System.out.println(">>>>receive payload:" + response);
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONObject error = jsonObject.getJSONObject("error");
        Object messageResponse = prompt instanceof FunctionPrompt ? new FunctionMessageResponse(((FunctionPrompt)prompt).getFunctions(), (FunctionMessage)this.functionMessageParser.parse((Object)jsonObject)) : new AiMessageResponse((AiMessage)this.aiMessageParser.parse((Object)jsonObject));
        if (error != null && !error.isEmpty()) {
            messageResponse.setError(true);
            messageResponse.setErrorMessage(error.getString("message"));
            messageResponse.setErrorType(error.getString("type"));
            messageResponse.setErrorCode(error.getString("code"));
        }
        return (R)messageResponse;
    }

    public <R extends MessageResponse<?>> void chatStream(Prompt<R> prompt, StreamResponseListener<R> listener, ChatOptions options) {
        SseClient llmClient = new SseClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((OpenAiLlmConfig)this.getConfig()).getApiKey());
        String payload = OpenAiLLmUtil.promptToPayload(prompt, (OpenAiLlmConfig)this.config, options, true);
        String endpoint = ((OpenAiLlmConfig)this.config).getEndpoint();
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, listener, prompt, this.streamMessageParser, this.functionMessageParser);
        llmClient.start(endpoint + "/v1/chat/completions", headers, payload, (LlmClientListener)clientListener, this.config);
    }

    public VectorData embed(Document document, EmbeddingOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((OpenAiLlmConfig)this.getConfig()).getApiKey());
        String payload = OpenAiLLmUtil.promptToEmbeddingsPayload(document, options, (OpenAiLlmConfig)this.config);
        String endpoint = ((OpenAiLlmConfig)this.config).getEndpoint();
        String response = this.httpClient.post(endpoint + "/v1/embeddings", headers, payload);
        if (StringUtil.noText((String)response)) {
            return null;
        }
        if (((OpenAiLlmConfig)this.config).isDebug()) {
            System.out.println(">>>>receive payload:" + response);
        }
        VectorData vectorData = new VectorData();
        double[] embedding = (double[])JSONPath.read((String)response, (String)"$.data[0].embedding", double[].class);
        vectorData.setVector(embedding);
        return vectorData;
    }
}

