/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.client.netty;

import cn.hutool.core.util.IdUtil;
import com.aizuda.easy.retry.client.core.cache.GroupVersionCache;
import com.aizuda.easy.retry.client.core.config.EasyRetryProperties;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.enums.HeadersEnum;
import com.aizuda.easy.retry.common.core.log.LogUtils;
import com.aizuda.easy.retry.common.core.util.HostUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;

public class NettyChannel {
    private static final Logger log = LoggerFactory.getLogger(NettyChannel.class);
    private static final String HOST_ID = IdUtil.getSnowflake().nextIdStr();
    private static final int PORT = Integer.parseInt(System.getProperty("easy-retry.port", String.valueOf(8080)));
    private static final String HOST = System.getProperty("easy-retry.host", HostUtils.getIp());
    private static Channel CHANNEL;

    private NettyChannel() {
    }

    public static void setChannel(Channel channel) {
        CHANNEL = channel;
    }

    public static void send(HttpMethod method, String url, String body) throws InterruptedException {
        String host;
        if (Objects.isNull(CHANNEL)) {
            LogUtils.error((Logger)log, (String)"send message but channel is null url:[{}] method:[{}] body:[{}] ", (Object[])new Object[]{url, method, body});
            return;
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, url, Unpooled.wrappedBuffer((byte[])body.getBytes(StandardCharsets.UTF_8)));
        ServerProperties serverProperties = (ServerProperties)SpringContext.CONTEXT.getBean(ServerProperties.class);
        EasyRetryProperties easyRetryProperties = (EasyRetryProperties)SpringContext.CONTEXT.getBean(EasyRetryProperties.class);
        Integer port = easyRetryProperties.getPort();
        if (Objects.isNull(port)) {
            port = Optional.ofNullable(serverProperties.getPort()).orElse(PORT);
        }
        if (StringUtils.isBlank((String)(host = easyRetryProperties.getHost()))) {
            host = HOST;
        }
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)request.content().readableBytes()).set(HeadersEnum.HOST_ID.getKey(), (Object)HOST_ID).set(HeadersEnum.HOST_IP.getKey(), (Object)host).set(HeadersEnum.GROUP_NAME.getKey(), (Object)EasyRetryProperties.getGroup()).set(HeadersEnum.CONTEXT_PATH.getKey(), (Object)Optional.ofNullable(serverProperties.getServlet().getContextPath()).orElse("/")).set(HeadersEnum.HOST_PORT.getKey(), (Object)port).set(HeadersEnum.VERSION.getKey(), (Object)GroupVersionCache.getVersion());
        CHANNEL.writeAndFlush((Object)request).sync();
    }
}

