/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.client.netty;

import com.aizuda.easy.retry.client.core.client.NettyClient;
import com.aizuda.easy.retry.client.core.client.netty.NettyHttpConnectClient;
import com.aizuda.easy.retry.client.core.client.netty.RpcContext;
import com.aizuda.easy.retry.client.core.client.proxy.RequestBuilder;
import com.aizuda.easy.retry.common.core.log.LogUtils;
import com.aizuda.easy.retry.common.core.model.NettyResult;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClientHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(NettyHttpClientHandler.class);
    private NettyClient client = RequestBuilder.newBuilder().client(NettyClient.class).callback(nettyResult -> LogUtils.info((Logger)log, (String)"heartbeat check requestId:[{}]", (Object[])new Object[]{nettyResult.getRequestId()})).build();
    private NettyHttpConnectClient nettyHttpConnectClient;

    public NettyHttpClientHandler(NettyHttpConnectClient nettyHttpConnectClient) {
        this.nettyHttpConnectClient = nettyHttpConnectClient;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
        FullHttpResponse response = msg;
        String content = response.content().toString(CharsetUtil.UTF_8);
        HttpHeaders headers = response.headers();
        LogUtils.info((Logger)log, (String)"Receive server data content:[{}], headers:[{}]", (Object[])new Object[]{content, headers});
        NettyResult nettyResult = (NettyResult)JsonUtil.parseObject((String)content, NettyResult.class);
        RpcContext.invoke(nettyResult.getRequestId(), nettyResult);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        LogUtils.debug((Logger)log, (String)"channelRegistered", (Object[])new Object[0]);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        LogUtils.debug((Logger)log, (String)"channelUnregistered", (Object[])new Object[0]);
        ctx.channel().eventLoop().schedule(() -> {
            try {
                this.nettyHttpConnectClient.reconnect();
            }
            catch (Exception e) {
                LogUtils.error((Logger)log, (String)"reconnect error ", (Throwable)e);
            }
        }, 10L, TimeUnit.SECONDS);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        LogUtils.debug((Logger)log, (String)"channelActive", (Object[])new Object[0]);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        LogUtils.debug((Logger)log, (String)"channelInactive", (Object[])new Object[0]);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
        LogUtils.debug((Logger)log, (String)"channelReadComplete", (Object[])new Object[0]);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        LogUtils.debug((Logger)log, (String)"channelWritabilityChanged", (Object[])new Object[0]);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LogUtils.error((Logger)log, (String)"easy-retry netty-http client exception", (Throwable)cause);
        super.exceptionCaught(ctx, cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        LogUtils.debug((Logger)log, (String)"userEventTriggered", (Object[])new Object[0]);
        if (evt instanceof IdleStateEvent) {
            this.client.beat("PING");
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

