/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.client.proxy;

import cn.hutool.core.date.StopWatch;
import cn.hutool.core.lang.Assert;
import com.aizuda.easy.retry.client.core.annotation.Mapping;
import com.aizuda.easy.retry.client.core.client.netty.NettyChannel;
import com.aizuda.easy.retry.client.core.client.netty.RpcContext;
import com.aizuda.easy.retry.client.core.exception.EasyRetryClientException;
import com.aizuda.easy.retry.client.core.exception.EasyRetryClientTimeOutException;
import com.aizuda.easy.retry.common.core.log.LogUtils;
import com.aizuda.easy.retry.common.core.model.EasyRetryRequest;
import io.netty.handler.codec.http.HttpMethod;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientInvokeHandler<R>
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(ClientInvokeHandler.class);
    private final Consumer<R> consumer;
    private final boolean async;
    private final long timeout;
    private final TimeUnit unit;

    public ClientInvokeHandler(boolean async, long timeout, TimeUnit unit, Consumer<R> consumer) {
        this.consumer = consumer;
        this.async = async;
        this.timeout = timeout;
        this.unit = unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R invoke(Object proxy, Method method, Object[] args) throws InterruptedException {
        StopWatch sw = new StopWatch();
        Mapping annotation = method.getAnnotation(Mapping.class);
        EasyRetryRequest easyRetryRequest = new EasyRetryRequest(args);
        sw.start("request start " + easyRetryRequest.getReqId());
        CompletableFuture completableFuture = null;
        if (this.async) {
            RpcContext.setCompletableFuture((Long)easyRetryRequest.getReqId(), this.consumer);
        } else {
            completableFuture = new CompletableFuture();
            RpcContext.setCompletableFuture((Long)easyRetryRequest.getReqId(), completableFuture);
        }
        try {
            NettyChannel.send(HttpMethod.valueOf((String)annotation.method().name()), annotation.path(), easyRetryRequest.toString());
        }
        finally {
            sw.stop();
        }
        LogUtils.info((Logger)log, (String)"request complete requestId:[{}] \u8017\u65f6:[{}ms]", (Object[])new Object[]{easyRetryRequest.getReqId(), sw.getTotalTimeMillis()});
        if (this.async) {
            return null;
        }
        Assert.notNull(completableFuture, () -> new EasyRetryClientException("completableFuture is null"));
        try {
            return (R)completableFuture.get(this.timeout, this.unit);
        }
        catch (ExecutionException e) {
            throw new EasyRetryClientException("Request to remote interface exception. path:[{}]", (Object)annotation.path());
        }
        catch (TimeoutException e) {
            throw new EasyRetryClientTimeOutException("Request to remote interface timed out. path:[{}]", (Object)annotation.path());
        }
    }
}

