/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.intercepter;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.client.core.annotation.Retryable;
import com.aizuda.easy.retry.client.core.cache.GroupVersionCache;
import com.aizuda.easy.retry.client.core.cache.RetryerInfoCache;
import com.aizuda.easy.retry.client.core.config.EasyRetryProperties;
import com.aizuda.easy.retry.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.easy.retry.client.core.retryer.RetryerInfo;
import com.aizuda.easy.retry.client.core.retryer.RetryerResultContext;
import com.aizuda.easy.retry.client.core.strategy.RetryStrategy;
import com.aizuda.easy.retry.common.core.alarm.Alarm;
import com.aizuda.easy.retry.common.core.alarm.AlarmContext;
import com.aizuda.easy.retry.common.core.alarm.EasyRetryAlarmFactory;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.enums.NotifySceneEnum;
import com.aizuda.easy.retry.common.core.enums.RetryResultStatusEnum;
import com.aizuda.easy.retry.common.core.log.LogUtils;
import com.aizuda.easy.retry.common.core.model.EasyRetryHeaders;
import com.aizuda.easy.retry.common.core.util.EnvironmentUtils;
import com.aizuda.easy.retry.server.model.dto.ConfigDTO;
import com.google.common.base.Defaults;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.AfterAdvice;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.CollectionUtils;

public class EasyRetryInterceptor
implements MethodInterceptor,
AfterAdvice,
Serializable,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(EasyRetryInterceptor.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static String retryErrorMoreThresholdTextMessageFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u91cd\u8bd5\u7ec4\u4ef6\u5f02\u5e38</font>  \r\n> \u540d\u79f0:{}  \r\n> \u65f6\u95f4:{}  \r\n> \u5f02\u5e38:{}  \n";
    private final StandardEnvironment standardEnvironment;
    private final RetryStrategy retryStrategy;

    public EasyRetryInterceptor(StandardEnvironment standardEnvironment, RetryStrategy localRetryStrategies) {
        this.standardEnvironment = standardEnvironment;
        this.retryStrategy = localRetryStrategies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        RetryerResultContext retryerResultContext;
        String traceId = UUID.randomUUID().toString();
        LogUtils.debug((Logger)log, (String)"Start entering the around method traceId:[{}]", (Object[])new Object[]{traceId});
        Retryable retryable = this.getAnnotationParameter(invocation.getMethod());
        String executorClassName = invocation.getThis().getClass().getName();
        String methodEntrance = this.getMethodEntrance(retryable, executorClassName);
        if (StrUtil.isBlank((CharSequence)RetrySiteSnapshot.getMethodEntrance())) {
            RetrySiteSnapshot.setMethodEntrance(methodEntrance);
        }
        Throwable throwable = null;
        Object result = null;
        try {
            result = invocation.proceed();
        }
        catch (Throwable t) {
            try {
                throwable = t;
            }
            catch (Throwable throwable2) {
                LogUtils.debug((Logger)log, (String)"Start retrying. traceId:[{}] scene:[{}] executorClassName:[{}]", (Object[])new Object[]{traceId, retryable.scene(), executorClassName});
                RetryerResultContext retryerResultContext2 = this.doHandlerRetry(invocation, traceId, retryable, executorClassName, methodEntrance, throwable);
                throw throwable2;
            }
            LogUtils.debug((Logger)log, (String)"Start retrying. traceId:[{}] scene:[{}] executorClassName:[{}]", (Object[])new Object[]{traceId, retryable.scene(), executorClassName});
            retryerResultContext = this.doHandlerRetry(invocation, traceId, retryable, executorClassName, methodEntrance, throwable);
        }
        LogUtils.debug((Logger)log, (String)"Start retrying. traceId:[{}] scene:[{}] executorClassName:[{}]", (Object[])new Object[]{traceId, retryable.scene(), executorClassName});
        retryerResultContext = this.doHandlerRetry(invocation, traceId, retryable, executorClassName, methodEntrance, throwable);
        LogUtils.debug((Logger)log, (String)"Method return value is [{}]. traceId:[{}]", (Object[])new Object[]{result, traceId, throwable});
        if (Objects.nonNull(retryerResultContext) && (retryerResultContext.getRetryResultStatusEnum().getStatus().equals(RetryResultStatusEnum.SUCCESS.getStatus()) || !retryable.isThrowException())) {
            Method method = invocation.getMethod();
            if (Objects.isNull(retryerResultContext.getResult()) && method.getReturnType().isPrimitive()) {
                return Defaults.defaultValue(method.getReturnType());
            }
            return retryerResultContext.getResult();
        }
        if (throwable != null) {
            throw throwable;
        }
        return result;
    }

    private RetryerResultContext doHandlerRetry(MethodInvocation invocation, String traceId, Retryable retryable, String executorClassName, String methodEntrance, Throwable throwable) {
        if (!RetrySiteSnapshot.isMethodEntrance(methodEntrance) || RetrySiteSnapshot.isRunning() || Objects.isNull(throwable) || RetrySiteSnapshot.isRetryFlow() || RetrySiteSnapshot.isRetryForStatusCode() || !this.validate(throwable, RetryerInfoCache.get(retryable.scene(), executorClassName))) {
            if (!RetrySiteSnapshot.isMethodEntrance(methodEntrance)) {
                LogUtils.debug((Logger)log, (String)"Non-method entry does not enable local retries. traceId:[{}] [{}]", (Object[])new Object[]{traceId, RetrySiteSnapshot.getMethodEntrance()});
            } else if (RetrySiteSnapshot.isRunning()) {
                LogUtils.debug((Logger)log, (String)"Existing running retry tasks do not enable local retries. traceId:[{}] [{}]", (Object[])new Object[]{traceId, RetrySiteSnapshot.EnumStage.valueOfStage(RetrySiteSnapshot.getStage())});
            } else if (Objects.isNull(throwable)) {
                LogUtils.debug((Logger)log, (String)"No exception, no local retries. traceId:[{}]", (Object[])new Object[]{traceId});
            } else if (RetrySiteSnapshot.isRetryFlow()) {
                LogUtils.debug((Logger)log, (String)"Retry traffic does not enable local retries. traceId:[{}] [{}]", (Object[])new Object[]{traceId, RetrySiteSnapshot.getRetryHeader()});
            } else if (RetrySiteSnapshot.isRetryForStatusCode()) {
                LogUtils.debug((Logger)log, (String)"Existing exception retry codes do not enable local retries. traceId:[{}]", (Object[])new Object[]{traceId});
            } else if (!this.validate(throwable, RetryerInfoCache.get(retryable.scene(), executorClassName))) {
                LogUtils.debug((Logger)log, (String)"Exception mismatch. traceId:[{}]", (Object[])new Object[]{traceId});
            } else {
                LogUtils.debug((Logger)log, (String)"Unknown situations do not enable local retry scenarios. traceId:[{}]", (Object[])new Object[]{traceId});
            }
            return null;
        }
        return this.openRetry(invocation, traceId, retryable, executorClassName, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RetryerResultContext openRetry(MethodInvocation point, String traceId, Retryable retryable, String executorClassName, Throwable throwable) {
        try {
            this.initHeaders(retryable);
            RetryerResultContext context = this.retryStrategy.openRetry(retryable.scene(), executorClassName, point.getArguments());
            if (RetryResultStatusEnum.SUCCESS.getStatus().equals(context.getRetryResultStatusEnum().getStatus())) {
                LogUtils.debug((Logger)log, (String)"local retry successful. traceId:[{}] result:[{}]", (Object[])new Object[]{traceId, context.getResult()});
            } else {
                LogUtils.info((Logger)log, (String)"local retry result. traceId:[{}] throwable:[{}]", (Object[])new Object[]{traceId, context.getThrowable()});
            }
            RetryerResultContext retryerResultContext = context;
            return retryerResultContext;
        }
        catch (Exception e) {
            LogUtils.error((Logger)log, (String)"retry component handling exception\uff0ctraceId:[{}]", (Object[])new Object[]{traceId, e});
            this.sendMessage(e);
        }
        finally {
            RetrySiteSnapshot.removeAll();
        }
        return null;
    }

    private void initHeaders(Retryable retryable) {
        EasyRetryHeaders easyRetryHeaders = new EasyRetryHeaders();
        easyRetryHeaders.setEasyRetry(Boolean.TRUE.booleanValue());
        easyRetryHeaders.setEasyRetryId(IdUtil.getSnowflakeNextIdStr());
        easyRetryHeaders.setDdl(GroupVersionCache.getDdl(retryable.scene()));
        RetrySiteSnapshot.setRetryHeader(easyRetryHeaders);
    }

    private void sendMessage(Exception e) {
        try {
            ConfigDTO.Notify notifyAttribute = GroupVersionCache.getNotifyAttribute(NotifySceneEnum.CLIENT_COMPONENT_ERROR.getNotifyScene());
            if (Objects.nonNull(notifyAttribute)) {
                AlarmContext context = AlarmContext.build().text(retryErrorMoreThresholdTextMessageFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), EasyRetryProperties.getGroup(), LocalDateTime.now().format(formatter), e.getMessage()}).title("retry component handling exception:[{}]", new Object[]{EasyRetryProperties.getGroup()}).notifyAttribute(notifyAttribute.getNotifyAttribute());
                Alarm alarmType = ((EasyRetryAlarmFactory)SpringContext.getBeanByType(EasyRetryAlarmFactory.class)).getAlarmType(notifyAttribute.getNotifyType());
                alarmType.asyncSendMessage((Object)context);
            }
        }
        catch (Exception e1) {
            LogUtils.error((Logger)log, (String)"Client failed to send component exception alert.", (Throwable)e1);
        }
    }

    public String getMethodEntrance(Retryable retryable, String executorClassName) {
        if (Objects.isNull(retryable)) {
            return "";
        }
        return retryable.scene().concat("_").concat(executorClassName);
    }

    private Retryable getAnnotationParameter(Method method) {
        Retryable retryable = null;
        if (method.isAnnotationPresent(Retryable.class)) {
            retryable = method.getAnnotation(Retryable.class);
        }
        if (retryable == null) {
            retryable = (Retryable)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Retryable.class);
        }
        return retryable;
    }

    public int getOrder() {
        String order = this.standardEnvironment.getProperty("easy-retry.aop.order", String.valueOf(Integer.MIN_VALUE));
        return Integer.parseInt(order);
    }

    private boolean validate(Throwable throwable, RetryerInfo retryerInfo) {
        Set<Class<? extends Throwable>> exclude = retryerInfo.getExclude();
        Set<Class<? extends Throwable>> include = retryerInfo.getInclude();
        if (CollectionUtils.isEmpty(include) && CollectionUtils.isEmpty(exclude)) {
            return true;
        }
        for (Class<? extends Throwable> e : include) {
            if (!e.isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        if (!CollectionUtils.isEmpty(exclude)) {
            for (Class<? extends Throwable> e : exclude) {
                if (!e.isAssignableFrom(throwable.getClass())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

