/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.intercepter;

import com.aizuda.easy.retry.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.easy.retry.common.core.log.LogUtils;
import com.aizuda.easy.retry.common.core.model.EasyRetryHeaders;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class HeaderAspect {
    private static final Logger log = LoggerFactory.getLogger(HeaderAspect.class);

    public void before() {
        if (this.skip()) {
            return;
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        String xRetry = attributes.getRequest().getHeader("easy-retry");
        if (Objects.nonNull(xRetry)) {
            RetrySiteSnapshot.setEntryMethodTime(System.currentTimeMillis());
            LogUtils.info((Logger)log, (String)"easy-retry request header :[{}]", (Object[])new Object[]{xRetry});
            RetrySiteSnapshot.setRetryHeader((EasyRetryHeaders)JsonUtil.parseObject((String)xRetry, EasyRetryHeaders.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@within(org.springframework.web.bind.annotation.RestController)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        this.before();
        Throwable throwable = null;
        Object result = null;
        try {
            result = point.proceed();
        }
        catch (Throwable t) {
            throwable = t;
        }
        finally {
            this.afterReturning();
        }
        if (throwable != null) {
            throw throwable;
        }
        return result;
    }

    public void afterReturning() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = attributes.getResponse();
        response.addHeader("easy-retry-status", RetrySiteSnapshot.getRetryStatusCode());
        if (this.skip()) {
            return;
        }
        if (Objects.nonNull(RetrySiteSnapshot.getStage()) && RetrySiteSnapshot.EnumStage.REMOTE.getStage() == RetrySiteSnapshot.getStage().intValue()) {
            return;
        }
        RetrySiteSnapshot.removeRetryHeader();
        RetrySiteSnapshot.removeRetryStatusCode();
        RetrySiteSnapshot.removeEntryMethodTime();
    }

    private boolean skip() {
        Integer stage = RetrySiteSnapshot.getStage();
        return Objects.nonNull(stage) && RetrySiteSnapshot.EnumStage.LOCAL.getStage() == RetrySiteSnapshot.getStage().intValue();
    }
}

