/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.intercepter;

import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.client.core.RetrySiteSnapshotContext;
import com.aizuda.easy.retry.client.core.exception.EasyRetryClientException;
import com.aizuda.easy.retry.client.core.loader.EasyRetrySpiLoader;
import com.aizuda.easy.retry.common.core.model.EasyRetryHeaders;
import java.util.Objects;
import java.util.Optional;

public class RetrySiteSnapshot {
    private static final RetrySiteSnapshotContext<Integer> RETRY_STAGE = EasyRetrySpiLoader.loadRetrySiteSnapshotContext();
    private static final RetrySiteSnapshotContext<String> RETRY_CLASS_METHOD_ENTRANCE = EasyRetrySpiLoader.loadRetrySiteSnapshotContext();
    private static final RetrySiteSnapshotContext<Integer> RETRY_STATUS = EasyRetrySpiLoader.loadRetrySiteSnapshotContext();
    private static final RetrySiteSnapshotContext<EasyRetryHeaders> RETRY_HEADER = EasyRetrySpiLoader.loadRetrySiteSnapshotContext();
    private static final RetrySiteSnapshotContext<String> RETRY_STATUS_CODE = EasyRetrySpiLoader.loadRetrySiteSnapshotContext();
    private static final RetrySiteSnapshotContext<Long> ENTRY_METHOD_TIME = EasyRetrySpiLoader.loadRetrySiteSnapshotContext();

    public static Integer getStage() {
        return RETRY_STAGE.get();
    }

    public static void setStage(int stage) {
        RETRY_STAGE.set(stage);
    }

    public static String getMethodEntrance() {
        return RETRY_CLASS_METHOD_ENTRANCE.get();
    }

    public static void setMethodEntrance(String methodEntrance) {
        RETRY_CLASS_METHOD_ENTRANCE.set(methodEntrance);
    }

    public static void removeMethodEntrance() {
        RETRY_CLASS_METHOD_ENTRANCE.remove();
    }

    public static boolean isMethodEntrance(String methodEntrance) {
        if (StrUtil.isBlank((CharSequence)RetrySiteSnapshot.getMethodEntrance())) {
            return false;
        }
        return RetrySiteSnapshot.getMethodEntrance().equals(methodEntrance);
    }

    public static Integer getStatus() {
        return Optional.ofNullable(RETRY_STATUS.get()).orElse(EnumStatus.COMPLETE.status);
    }

    public static void setStatus(Integer status) {
        RETRY_STATUS.set(status);
    }

    public static boolean isRunning() {
        return EnumStatus.RUNNING.status == RetrySiteSnapshot.getStatus();
    }

    public static EasyRetryHeaders getRetryHeader() {
        return RETRY_HEADER.get();
    }

    public static void setRetryHeader(EasyRetryHeaders headers) {
        RETRY_HEADER.set(headers);
    }

    public static boolean isRetryFlow() {
        EasyRetryHeaders retryHeader = RetrySiteSnapshot.getRetryHeader();
        if (Objects.nonNull(retryHeader)) {
            return retryHeader.isEasyRetry();
        }
        return false;
    }

    public static String getRetryStatusCode() {
        return RETRY_STATUS_CODE.get();
    }

    public static void setRetryStatusCode(String statusCode) {
        RETRY_STATUS_CODE.set(statusCode);
    }

    public static boolean isRetryForStatusCode() {
        return Objects.nonNull(RetrySiteSnapshot.getRetryStatusCode()) && RetrySiteSnapshot.getRetryStatusCode().equals("519");
    }

    public static Long getEntryMethodTime() {
        return ENTRY_METHOD_TIME.get();
    }

    public static void setEntryMethodTime(long entryMethodTime) {
        ENTRY_METHOD_TIME.set(entryMethodTime);
    }

    public static void removeEntryMethodTime() {
        ENTRY_METHOD_TIME.remove();
    }

    public static void removeRetryHeader() {
        RETRY_HEADER.remove();
    }

    public static void removeRetryStatusCode() {
        RETRY_STATUS_CODE.remove();
    }

    public static void removeStage() {
        RETRY_STAGE.remove();
    }

    public static void removeStatus() {
        RETRY_STATUS.remove();
    }

    public static void removeAll() {
        RetrySiteSnapshot.removeStatus();
        RetrySiteSnapshot.removeMethodEntrance();
        RetrySiteSnapshot.removeStage();
        RetrySiteSnapshot.removeEntryMethodTime();
        RetrySiteSnapshot.removeRetryHeader();
        RetrySiteSnapshot.removeRetryStatusCode();
    }

    public static enum EnumStatus {
        RUNNING(1),
        COMPLETE(2);

        private final int status;

        private EnumStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }

    public static enum EnumStage {
        LOCAL(1),
        REMOTE(2),
        MANUAL_REPORT(3);

        private final int stage;

        private EnumStage(int stage) {
            this.stage = stage;
        }

        public static EnumStage valueOfStage(int stage) {
            for (EnumStage value : EnumStage.values()) {
                if (value.getStage() != stage) continue;
                return value;
            }
            throw new EasyRetryClientException("unsupported stage");
        }

        public int getStage() {
            return this.stage;
        }
    }
}

