/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.report;

import com.aizuda.easy.retry.client.core.Lifecycle;
import com.aizuda.easy.retry.client.core.config.EasyRetryProperties;
import com.aizuda.easy.retry.client.core.report.AbstractReport;
import com.aizuda.easy.retry.client.core.report.ReportListener;
import com.aizuda.easy.retry.client.core.retryer.RetryerInfo;
import com.aizuda.easy.retry.client.core.window.SlidingWindow;
import com.aizuda.easy.retry.server.model.dto.RetryTaskDTO;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncReport
extends AbstractReport
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(AsyncReport.class);
    @Autowired
    private EasyRetryProperties easyRetryProperties;
    private SlidingWindow<RetryTaskDTO> slidingWindow;

    @Override
    public boolean supports(boolean async) {
        return async;
    }

    @Override
    public boolean doReport(RetryerInfo retryerInfo, Object[] params) {
        return this.syncReport(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), params, retryerInfo.getTimeout(), retryerInfo.getUnit());
    }

    public Boolean syncReport(String scene, String targetClassName, Object[] args, long timeout, TimeUnit unit) {
        RetryTaskDTO retryTaskDTO = this.buildRetryTaskDTO(scene, targetClassName, args);
        this.slidingWindow.add(retryTaskDTO);
        return Boolean.TRUE;
    }

    @Override
    public void start() {
        EasyRetryProperties.SlidingWindowConfig slidingWindowConfig = this.easyRetryProperties.getSlidingWindow();
        this.slidingWindow = SlidingWindow.Builder.newBuilder().withTotalThreshold(slidingWindowConfig.getTotalThreshold()).withWindowTotalThreshold(slidingWindowConfig.getWindowTotalThreshold()).withDuration(slidingWindowConfig.getDuration(), slidingWindowConfig.getChronoUnit()).withListener(new ReportListener()).build();
        this.slidingWindow.start();
    }

    @Override
    public void close() {
        log.info("AsyncReport about to shutdown");
        this.slidingWindow.end();
        log.info("AsyncReport has been shutdown");
    }
}

