/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.report;

import com.aizuda.easy.retry.client.core.client.NettyClient;
import com.aizuda.easy.retry.client.core.client.proxy.RequestBuilder;
import com.aizuda.easy.retry.client.core.report.AbstractReport;
import com.aizuda.easy.retry.client.core.retryer.RetryerInfo;
import com.aizuda.easy.retry.common.core.log.LogUtils;
import com.aizuda.easy.retry.common.core.model.NettyResult;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.server.model.dto.RetryTaskDTO;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SyncReport
extends AbstractReport {
    private static final Logger log = LoggerFactory.getLogger(SyncReport.class);

    @Override
    public boolean supports(boolean async) {
        return !async;
    }

    @Override
    public boolean doReport(RetryerInfo retryerInfo, Object[] params) {
        return this.syncReport(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), params, retryerInfo.getTimeout(), retryerInfo.getUnit());
    }

    public Boolean syncReport(String scene, String targetClassName, Object[] args, long timeout, TimeUnit unit) {
        RetryTaskDTO retryTaskDTO = this.buildRetryTaskDTO(scene, targetClassName, args);
        NettyClient client = RequestBuilder.newBuilder().client(NettyClient.class).async(Boolean.FALSE).timeout(timeout).unit(unit).build();
        NettyResult result = client.reportRetryInfo(Collections.singletonList(retryTaskDTO));
        LogUtils.debug((Logger)log, (String)"Data report result result:[{}]", (Object[])new Object[]{JsonUtil.toJsonString((Object)result)});
        return (Boolean)result.getData();
    }
}

