/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.serializer;

import com.aizuda.easy.retry.client.core.RetryArgSerializer;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class HessianSerializer
implements RetryArgSerializer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String serialize(Object t) {
        if (Objects.isNull(t)) {
            return "";
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            HessianOutput ho = new HessianOutput((OutputStream)os);
            ho.writeObject(t);
            String string = Base64.getEncoder().encodeToString(os.toByteArray());
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("HessianSerializationConverter.serialize failed.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object deSerialize(String infoStr, Class aClass, Method method) {
        if (StringUtils.isBlank((String)infoStr)) {
            return null;
        }
        byte[] convertBytes = Base64.getDecoder().decode(infoStr);
        try (ByteArrayInputStream is = new ByteArrayInputStream(convertBytes);){
            HessianInput hi = new HessianInput((InputStream)is);
            Object object = hi.readObject(Object[].class);
            return object;
        }
        catch (IOException e) {
            throw new IllegalStateException("HessianSerializationConverter.deSerialize failed.", e);
        }
    }
}

