/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.strategy;

import com.aizuda.easy.retry.client.core.Report;
import com.aizuda.easy.retry.client.core.RetryExecutor;
import com.aizuda.easy.retry.client.core.RetryExecutorParameter;
import com.aizuda.easy.retry.client.core.cache.GroupVersionCache;
import com.aizuda.easy.retry.client.core.config.EasyRetryProperties;
import com.aizuda.easy.retry.client.core.event.EasyRetryListener;
import com.aizuda.easy.retry.client.core.executor.GuavaRetryExecutor;
import com.aizuda.easy.retry.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.easy.retry.client.core.loader.EasyRetrySpiLoader;
import com.aizuda.easy.retry.client.core.retryer.RetryerInfo;
import com.aizuda.easy.retry.client.core.retryer.RetryerResultContext;
import com.aizuda.easy.retry.client.core.strategy.RetryStrategy;
import com.aizuda.easy.retry.common.core.alarm.Alarm;
import com.aizuda.easy.retry.common.core.alarm.AlarmContext;
import com.aizuda.easy.retry.common.core.alarm.EasyRetryAlarmFactory;
import com.aizuda.easy.retry.common.core.enums.NotifySceneEnum;
import com.aizuda.easy.retry.common.core.log.LogUtils;
import com.aizuda.easy.retry.common.core.util.EnvironmentUtils;
import com.aizuda.easy.retry.server.model.dto.ConfigDTO;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategy;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRetryStrategies
implements RetryStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractRetryStrategies.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static String retryErrorMoreThresholdTextMessageFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u91cd\u8bd5\u7ec4\u4ef6\u5f02\u5e38</font>  \r\n> \u540d\u79f0:{}  \r\n> \u65f6\u95f4:{}  \r\n> \u5f02\u5e38:{}  \n";
    private final List<EasyRetryListener> easyRetryListeners = EasyRetrySpiLoader.loadEasyRetryListener();
    @Autowired
    private EasyRetryAlarmFactory easyRetryAlarmFactory;
    @Autowired
    private List<Report> reports;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetryerResultContext openRetry(String sceneName, String executorClassName, Object[] params) {
        RetryerResultContext retryerResultContext = new RetryerResultContext();
        GuavaRetryExecutor retryExecutor = new GuavaRetryExecutor(sceneName, executorClassName);
        RetryerInfo retryerInfo = retryExecutor.getRetryerInfo();
        if (!this.preValidator(retryerInfo, retryerResultContext)) {
            return retryerResultContext;
        }
        RetrySiteSnapshot.setStatus(RetrySiteSnapshot.EnumStatus.RUNNING.getStatus());
        this.setStage();
        Retryer retryer = retryExecutor.build(this.getRetryExecutorParameter(retryerInfo));
        retryerResultContext.setRetryerInfo(retryerInfo);
        try {
            for (EasyRetryListener easyRetryListener : this.easyRetryListeners) {
                easyRetryListener.beforeRetry(sceneName, executorClassName, params);
            }
            Object result = retryExecutor.call(retryer, this.doGetCallable(retryExecutor, params), this.getRetryErrorConsumer(retryerResultContext, params), this.getRetrySuccessConsumer(retryerResultContext));
            retryerResultContext.setResult(result);
        }
        catch (Exception e) {
            log.error("\u91cd\u8bd5\u671f\u95f4\u53d1\u751f\u975e\u9884\u671f\u5f02\u5e38, sceneName:[{}] executorClassName:[{}]", new Object[]{sceneName, executorClassName, e});
            retryerResultContext.setMessage("\u975e\u9884\u671f\u5f02\u5e38" + e.getMessage());
            this.unexpectedError(e, retryerResultContext);
            this.sendMessage(e);
        }
        finally {
            RetrySiteSnapshot.setStatus(RetrySiteSnapshot.EnumStatus.COMPLETE.getStatus());
        }
        return retryerResultContext;
    }

    protected abstract void setStage();

    protected Consumer<Object> getRetrySuccessConsumer(RetryerResultContext retryerResultContext) {
        return o -> {
            this.success(retryerResultContext);
            Object result = retryerResultContext.getResult();
            RetryerInfo retryerInfo = retryerResultContext.getRetryerInfo();
            for (EasyRetryListener easyRetryListener : this.easyRetryListeners) {
                easyRetryListener.successOnRetry(result, retryerInfo.getScene(), retryerInfo.getExecutorClassName());
            }
            this.doRetrySuccessConsumer(retryerResultContext).accept(retryerResultContext);
        };
    }

    protected abstract Consumer<Object> doRetrySuccessConsumer(RetryerResultContext var1);

    private Consumer<Throwable> getRetryErrorConsumer(RetryerResultContext context, Object ... params) {
        return throwable -> {
            context.setThrowable((Throwable)throwable);
            context.setMessage(throwable.getMessage());
            this.error(context);
            RetryerInfo retryerInfo = context.getRetryerInfo();
            try {
                for (EasyRetryListener easyRetryListener : this.easyRetryListeners) {
                    easyRetryListener.failureOnRetry(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), (Throwable)throwable);
                }
            }
            catch (Exception e) {
                log.error("\u5931\u8d25\u76d1\u542c\u8005\u6a21\u5f0f \u5904\u7406\u5931\u8d25 ", (Throwable)e);
                throw e;
            }
            this.doGetRetryErrorConsumer(retryerInfo, params).accept((Throwable)throwable);
        };
    }

    protected abstract void error(RetryerResultContext var1);

    protected abstract boolean preValidator(RetryerInfo var1, RetryerResultContext var2);

    protected abstract void unexpectedError(Exception var1, RetryerResultContext var2);

    protected abstract void success(RetryerResultContext var1);

    protected abstract Consumer<Throwable> doGetRetryErrorConsumer(RetryerInfo var1, Object[] var2);

    protected abstract Callable doGetCallable(RetryExecutor<WaitStrategy, StopStrategy> var1, Object[] var2);

    protected abstract RetryExecutorParameter<WaitStrategy, StopStrategy> getRetryExecutorParameter(RetryerInfo var1);

    protected boolean doReport(RetryerInfo retryerInfo, Object[] params) {
        for (Report report : this.reports) {
            if (!report.supports(retryerInfo.isAsync())) continue;
            return report.report(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), params);
        }
        return Boolean.FALSE;
    }

    private void sendMessage(Exception e) {
        try {
            ConfigDTO.Notify notifyAttribute = GroupVersionCache.getNotifyAttribute(NotifySceneEnum.CLIENT_COMPONENT_ERROR.getNotifyScene());
            if (Objects.nonNull(notifyAttribute)) {
                AlarmContext context = AlarmContext.build().text(retryErrorMoreThresholdTextMessageFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), EasyRetryProperties.getGroup(), LocalDateTime.now().format(formatter), e.getMessage()}).title("retry component handling exception:[{}]", new Object[]{EasyRetryProperties.getGroup()}).notifyAttribute(notifyAttribute.getNotifyAttribute());
                Alarm alarmType = this.easyRetryAlarmFactory.getAlarmType(notifyAttribute.getNotifyType());
                alarmType.asyncSendMessage((Object)context);
            }
        }
        catch (Exception e1) {
            LogUtils.error((Logger)log, (String)"Client failed to send component exception alert.", (Throwable)e1);
        }
    }
}

