/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.strategy;

import com.aizuda.easy.retry.client.core.RetryExecutor;
import com.aizuda.easy.retry.client.core.RetryExecutorParameter;
import com.aizuda.easy.retry.client.core.exception.EasyRetryClientException;
import com.aizuda.easy.retry.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.easy.retry.client.core.retryer.RetryType;
import com.aizuda.easy.retry.client.core.retryer.RetryerInfo;
import com.aizuda.easy.retry.client.core.retryer.RetryerResultContext;
import com.aizuda.easy.retry.client.core.strategy.AbstractRetryStrategies;
import com.aizuda.easy.retry.common.core.enums.RetryResultStatusEnum;
import com.aizuda.easy.retry.common.core.log.LogUtils;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LocalRetryStrategies
extends AbstractRetryStrategies {
    private static final Logger log = LoggerFactory.getLogger(LocalRetryStrategies.class);

    @Override
    public boolean supports(int stage, RetryType retryType) {
        return RetrySiteSnapshot.EnumStage.LOCAL.getStage() == stage;
    }

    @Override
    protected void setStage() {
        RetrySiteSnapshot.setStage(RetrySiteSnapshot.EnumStage.LOCAL.getStage());
    }

    @Override
    protected Consumer<Object> doRetrySuccessConsumer(RetryerResultContext context) {
        return o -> {
            RetryerInfo retryerInfo = context.getRetryerInfo();
            if (retryerInfo.getRetryType() == RetryType.ONLY_REMOTE) {
                context.setRetryResultStatusEnum(RetryResultStatusEnum.FAILURE);
            } else {
                LogUtils.debug((Logger)log, (String)"doRetrySuccessConsumer \u91cd\u8bd5\u6210\u529f", (Object[])new Object[0]);
            }
        };
    }

    @Override
    protected void error(RetryerResultContext context) {
        context.setRetryResultStatusEnum(RetryResultStatusEnum.FAILURE);
    }

    @Override
    protected boolean preValidator(RetryerInfo retryerInfo, RetryerResultContext resultContext) {
        if (RetrySiteSnapshot.isRunning()) {
            resultContext.setRetryResultStatusEnum(RetryResultStatusEnum.FAILURE);
            resultContext.setMessage("\u6267\u884c\u91cd\u8bd5\u68c0\u9a8c\u4e0d\u901a\u8fc7 \u539f\u56e0: \u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u91cd\u8bd5\u4efb\u52a1");
            return false;
        }
        if (RetrySiteSnapshot.isRetryForStatusCode()) {
            resultContext.setRetryResultStatusEnum(RetryResultStatusEnum.FAILURE);
            resultContext.setMessage("\u6267\u884c\u91cd\u8bd5\u68c0\u9a8c\u4e0d\u901a\u8fc7 \u539f\u56e0: \u4e0b\u6e38\u6807\u5fd7\u7981\u6b62\u91cd\u8bd5");
            return false;
        }
        return true;
    }

    @Override
    protected void unexpectedError(Exception e, RetryerResultContext retryerResultContext) {
        retryerResultContext.setRetryResultStatusEnum(RetryResultStatusEnum.FAILURE);
    }

    @Override
    protected void success(RetryerResultContext retryerResultContext) {
        retryerResultContext.setRetryResultStatusEnum(RetryResultStatusEnum.SUCCESS);
    }

    @Override
    public Consumer<Throwable> doGetRetryErrorConsumer(RetryerInfo retryerInfo, Object[] params) {
        return throwable -> {
            log.info("\u5185\u5b58\u91cd\u8bd5\u5b8c\u6210\u4e14\u5f02\u5e38\u672a\u88ab\u89e3\u51b3 scene:[{}]", (Object)retryerInfo.getScene());
            if (RetryType.LOCAL_REMOTE.name().equals(retryerInfo.getRetryType().name())) {
                log.debug("\u4e0a\u62a5 scene:[{}]", (Object)retryerInfo.getScene());
                this.doReport(retryerInfo, params);
            }
        };
    }

    @Override
    public Callable doGetCallable(RetryExecutor<WaitStrategy, StopStrategy> retryExecutor, Object ... params) {
        RetryerInfo retryerInfo = retryExecutor.getRetryerInfo();
        RetryType retryType = retryerInfo.getRetryType();
        switch (retryType) {
            case ONLY_LOCAL: 
            case LOCAL_REMOTE: {
                RetrySiteSnapshot.setEntryMethodTime(System.currentTimeMillis());
                return () -> retryExecutor.execute(params);
            }
            case ONLY_REMOTE: {
                log.debug("\u4e0a\u62a5 scene:[{}]", (Object)retryerInfo.getScene());
                this.doReport(retryerInfo, params);
                RetrySiteSnapshot.setStage(RetrySiteSnapshot.EnumStage.REMOTE.getStage());
                return () -> null;
            }
        }
        throw new EasyRetryClientException("\u5f02\u5e38\u91cd\u8bd5\u6a21\u5f0f [{}]", (Object)retryType.name());
    }

    @Override
    public RetryExecutorParameter<WaitStrategy, StopStrategy> getRetryExecutorParameter(final RetryerInfo retryerInfo) {
        return new RetryExecutorParameter<WaitStrategy, StopStrategy>(){

            @Override
            public WaitStrategy backOff() {
                return WaitStrategies.fixedWait((long)retryerInfo.getLocalInterval().intValue(), (TimeUnit)TimeUnit.SECONDS);
            }

            @Override
            public StopStrategy stop() {
                return StopStrategies.stopAfterAttempt((int)retryerInfo.getLocalTimes());
            }

            @Override
            public List<RetryListener> getRetryListeners() {
                return Collections.singletonList(new RetryListener(){

                    public <V> void onRetry(Attempt<V> attempt) {
                        if (attempt.hasException()) {
                            RetryType retryType = retryerInfo.getRetryType();
                            switch (retryType) {
                                case ONLY_LOCAL: 
                                case LOCAL_REMOTE: {
                                    LogUtils.error((Logger)log, (String)"[{}] \u672c\u5730\u91cd\u8bd5\u6267\u884c\u5931\u8d25\uff0c\u7b2c[{}]\u6b21\u91cd\u8bd5", (Object[])new Object[]{retryerInfo.getScene(), attempt.getAttemptNumber()});
                                    break;
                                }
                                case ONLY_REMOTE: {
                                    LogUtils.error((Logger)log, (String)"[{}] \u4e0a\u62a5\u670d\u52a1\u7aef\u6267\u884c\u5931\u8d25\uff0c\u7b2c[{}]\u6b21\u91cd\u8bd5", (Object[])new Object[]{retryerInfo.getScene(), attempt.getAttemptNumber()});
                                    break;
                                }
                                default: {
                                    throw new EasyRetryClientException("\u5f02\u5e38\u91cd\u8bd5\u6a21\u5f0f [{}]", (Object)retryType.name());
                                }
                            }
                        } else {
                            RetryType retryType = retryerInfo.getRetryType();
                            switch (retryType) {
                                case ONLY_LOCAL: 
                                case LOCAL_REMOTE: {
                                    LogUtils.info((Logger)log, (String)"[{}] \u672c\u5730\u91cd\u8bd5\u6267\u884c\u6210\u529f.", (Object[])new Object[]{retryerInfo.getScene()});
                                    break;
                                }
                                case ONLY_REMOTE: {
                                    LogUtils.info((Logger)log, (String)"[{}] \u4e0a\u62a5\u670d\u52a1\u7aef\u6267\u884c\u6210\u529f.", (Object[])new Object[]{retryerInfo.getScene()});
                                    break;
                                }
                                default: {
                                    throw new EasyRetryClientException("\u5f02\u5e38\u91cd\u8bd5\u6a21\u5f0f [{}]", (Object)retryType.name());
                                }
                            }
                        }
                    }
                });
            }
        };
    }
}

