/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.strategy;

import com.aizuda.easy.retry.client.core.RetryExecutor;
import com.aizuda.easy.retry.client.core.RetryExecutorParameter;
import com.aizuda.easy.retry.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.easy.retry.client.core.retryer.RetryType;
import com.aizuda.easy.retry.client.core.retryer.RetryerInfo;
import com.aizuda.easy.retry.client.core.retryer.RetryerResultContext;
import com.aizuda.easy.retry.client.core.strategy.AbstractRetryStrategies;
import com.aizuda.easy.retry.common.core.enums.RetryResultStatusEnum;
import com.aizuda.easy.retry.common.core.log.LogUtils;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class RemoteRetryStrategies
extends AbstractRetryStrategies {
    private static final Logger log = LoggerFactory.getLogger(RemoteRetryStrategies.class);

    @Override
    public boolean supports(int stage, RetryType retryType) {
        return RetrySiteSnapshot.EnumStage.REMOTE.getStage() == stage;
    }

    @Override
    protected void setStage() {
        RetrySiteSnapshot.setStage(RetrySiteSnapshot.EnumStage.REMOTE.getStage());
    }

    @Override
    protected Consumer<Object> doRetrySuccessConsumer(RetryerResultContext context) {
        return o -> LogUtils.debug((Logger)log, (String)"RemoteRetryStrategies doRetrySuccessConsumer ", (Object[])new Object[0]);
    }

    @Override
    protected void error(RetryerResultContext context) {
        context.setRetryResultStatusEnum(RetryResultStatusEnum.FAILURE);
    }

    @Override
    protected boolean preValidator(RetryerInfo retryerInfo, RetryerResultContext resultContext) {
        if (RetrySiteSnapshot.isRunning()) {
            resultContext.setRetryResultStatusEnum(RetryResultStatusEnum.FAILURE);
            resultContext.setMessage("\u6267\u884c\u91cd\u8bd5\u68c0\u9a8c\u4e0d\u901a\u8fc7 \u539f\u56e0: \u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u91cd\u8bd5\u4efb\u52a1");
            return false;
        }
        return true;
    }

    @Override
    protected void unexpectedError(Exception e, RetryerResultContext retryerResultContext) {
        retryerResultContext.setRetryResultStatusEnum(RetryResultStatusEnum.SUCCESS);
    }

    @Override
    protected void success(RetryerResultContext retryerResultContext) {
        retryerResultContext.setRetryResultStatusEnum(RetryResultStatusEnum.SUCCESS);
    }

    @Override
    protected Consumer<Throwable> doGetRetryErrorConsumer(RetryerInfo retryerInfo, Object[] params) {
        return throwable -> LogUtils.debug((Logger)log, (String)"RemoteRetryStrategies doGetRetryErrorConsumer ", (Object[])new Object[0]);
    }

    @Override
    protected Callable doGetCallable(RetryExecutor<WaitStrategy, StopStrategy> retryExecutor, Object ... params) {
        return () -> retryExecutor.execute(params);
    }

    @Override
    protected RetryExecutorParameter<WaitStrategy, StopStrategy> getRetryExecutorParameter(RetryerInfo retryerInfo) {
        return new RetryExecutorParameter<WaitStrategy, StopStrategy>(){

            @Override
            public WaitStrategy backOff() {
                return WaitStrategies.fixedWait((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }

            @Override
            public StopStrategy stop() {
                return StopStrategies.stopAfterAttempt((int)1);
            }

            @Override
            public List<RetryListener> getRetryListeners() {
                return Collections.singletonList(new RetryListener(){

                    public <V> void onRetry(Attempt<V> attempt) {
                        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                        HttpServletRequest request = Objects.requireNonNull(attributes).getRequest();
                        Integer attemptNumber = (Integer)request.getAttribute("attemptNumber");
                        if (attempt.hasResult()) {
                            LogUtils.info((Logger)log, (String)"easy-retry \u8fdc\u7a0b\u91cd\u8bd5\u6210\u529f\uff0c\u7b2c[{}]\u6b21\u8c03\u5ea6", (Object[])new Object[]{attemptNumber});
                        }
                        if (attempt.hasException()) {
                            LogUtils.error((Logger)log, (String)"easy-retry \u8fdc\u7a0b\u91cd\u8bd5\u5931\u8d25\uff0c\u7b2c[{}]\u6b21\u8c03\u5ea6 ", (Object[])new Object[]{attemptNumber, attempt.getExceptionCause()});
                        }
                    }
                });
            }
        };
    }
}

