/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.window;

import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.core.window.LeapArray;
import com.aizuda.easy.retry.common.core.window.Listener;
import com.aizuda.easy.retry.common.core.window.WindowWrap;
import com.aizuda.easy.retry.server.model.dto.RetryTaskDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RetryLeapArray
extends LeapArray<ConcurrentLinkedQueue<RetryTaskDTO>> {
    private static final Logger log = LoggerFactory.getLogger(RetryLeapArray.class);
    protected List<Listener<RetryTaskDTO>> listenerList;

    public RetryLeapArray(int sampleCount, int intervalInMs) {
        super(sampleCount, intervalInMs);
    }

    public RetryLeapArray(int sampleCount, int intervalInMs, List<Listener<RetryTaskDTO>> listenerList) {
        super(sampleCount, intervalInMs);
        this.listenerList = listenerList;
    }

    public RetryLeapArray(int sampleCount, int intervalInMs, Listener<RetryTaskDTO> listener) {
        this(sampleCount, intervalInMs, Collections.singletonList(listener));
    }

    public ConcurrentLinkedQueue<RetryTaskDTO> newEmptyBucket(long timeMillis) {
        return new ConcurrentLinkedQueue<RetryTaskDTO>();
    }

    protected WindowWrap<ConcurrentLinkedQueue<RetryTaskDTO>> resetWindowTo(WindowWrap<ConcurrentLinkedQueue<RetryTaskDTO>> windowWrap, long startTime) {
        ConcurrentLinkedQueue deepCopy = new ConcurrentLinkedQueue((Collection)windowWrap.value());
        try {
            if (!CollectionUtils.isEmpty(deepCopy)) {
                for (Listener<RetryTaskDTO> listener : this.listenerList) {
                    listener.handler(new ArrayList(deepCopy));
                }
            }
        }
        catch (Exception e) {
            log.error("\u6ed1\u52a8\u7a97\u53e3\u76d1\u542c\u5668\u5904\u7406\u5931\u8d25 data:[{}]", (Object)JsonUtil.toJsonString((Object)windowWrap.value()), (Object)e);
        }
        ((ConcurrentLinkedQueue)windowWrap.value()).removeAll(deepCopy);
        windowWrap.resetTo(startTime);
        return windowWrap;
    }
}

