/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.window;

import com.aizuda.easy.retry.common.core.log.LogUtils;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.core.window.Listener;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SlidingWindow<T> {
    private static final Logger log = LoggerFactory.getLogger(SlidingWindow.class);
    public final TreeMap<LocalDateTime, ConcurrentLinkedQueue<T>> saveData = new TreeMap();
    private final Integer totalThreshold;
    private final Integer windowTotalThreshold;
    private final List<Listener<T>> listeners;
    private final ScheduledExecutorService threadPoolExecutor;
    private final long duration;
    private final ChronoUnit chronoUnit;
    private static final ReentrantLock SAVE_LOCK = new ReentrantLock();
    private static final ReentrantLock NOTICE_LOCK = new ReentrantLock();

    public SlidingWindow(int totalThreshold, int windowTotalThreshold, List<Listener<T>> listeners, ScheduledExecutorService threadPoolExecutor, long duration, ChronoUnit chronoUnit) {
        this.totalThreshold = totalThreshold;
        this.listeners = listeners;
        this.windowTotalThreshold = windowTotalThreshold;
        this.threadPoolExecutor = threadPoolExecutor;
        this.duration = duration;
        this.chronoUnit = chronoUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T data) {
        LocalDateTime now = LocalDateTime.now();
        if (this.isOpenNewWindow(now)) {
            SAVE_LOCK.lock();
            LocalDateTime windowPeriod = now.plus(this.duration, this.chronoUnit);
            try {
                if (this.isOpenNewWindow(now)) {
                    ConcurrentLinkedQueue<T> list = new ConcurrentLinkedQueue<T>();
                    list.add(data);
                    LogUtils.info((Logger)log, (String)"\u6dfb\u52a0\u65b0\u6570\u636e [{}] [{}] size:[{}]", (Object[])new Object[]{windowPeriod, Thread.currentThread().getName(), list.size()});
                    this.saveData.put(windowPeriod, list);
                    this.removeInvalidWindow();
                    this.alarmWindowTotal();
                }
                this.oldWindowAdd(data);
            }
            finally {
                SAVE_LOCK.unlock();
            }
        } else {
            this.oldWindowAdd(data);
        }
    }

    private void alarmWindowTotal() {
        if (this.saveData.size() > this.windowTotalThreshold) {
            log.warn("\u5f53\u524d\u5b58\u6d3b\u7684\u7a97\u53e3\u6570\u91cf\u8fc7\u591a \u603b\u91cf:[{}] > \u9608\u503c:[{}] ", (Object)this.saveData.size(), (Object)this.windowTotalThreshold);
        }
    }

    private void removeInvalidWindow() {
        for (int i = 0; i < this.saveData.size() - 1; ++i) {
            Map.Entry<LocalDateTime, ConcurrentLinkedQueue<T>> firstEntry = this.saveData.firstEntry();
            if (!CollectionUtils.isEmpty((Collection)firstEntry.getValue())) continue;
            this.saveData.remove(firstEntry.getKey());
        }
    }

    private void oldWindowAdd(T data) {
        LocalDateTime windowPeriod = this.getNewWindowPeriod();
        ConcurrentLinkedQueue<T> list = this.saveData.get(windowPeriod);
        list.add(data);
        if (list.size() >= this.totalThreshold) {
            this.doHandlerListener(windowPeriod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandlerListener(LocalDateTime windowPeriod) {
        NOTICE_LOCK.lock();
        try {
            ConcurrentLinkedQueue<T> list = this.saveData.get(windowPeriod);
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            ConcurrentLinkedQueue<T> deepCopy = new ConcurrentLinkedQueue<T>(list);
            this.clear(windowPeriod, deepCopy);
            if (CollectionUtils.isEmpty(deepCopy)) {
                return;
            }
            for (Listener<T> listener : this.listeners) {
                listener.handler(new ArrayList<T>(deepCopy));
            }
        }
        catch (Exception e) {
            log.error("\u5230\u8fbe\u603b\u91cf\u7a97\u53e3\u671f\u901a\u77e5\u5f02\u5e38", (Throwable)e);
        }
        finally {
            NOTICE_LOCK.unlock();
        }
    }

    private void removeInvalidWindow(LocalDateTime windowPeriod) {
        LocalDateTime currentTime = LocalDateTime.now().minus(this.duration * 2L, this.chronoUnit);
        if (windowPeriod.isBefore(currentTime)) {
            LogUtils.info((Logger)log, (String)"\u5220\u9664\u8fc7\u671f\u7a97\u53e3 windowPeriod:[{}] currentTime:[{}]", (Object[])new Object[]{windowPeriod, currentTime});
            this.saveData.remove(windowPeriod);
        }
    }

    private LocalDateTime getOldWindowPeriod() {
        return this.saveData.firstKey();
    }

    private LocalDateTime getNewWindowPeriod() {
        return this.saveData.lastKey();
    }

    private boolean isOpenNewWindow(LocalDateTime now) {
        if (this.saveData.size() == 0) {
            return true;
        }
        LocalDateTime windowPeriod = this.getNewWindowPeriod();
        return windowPeriod.isBefore(now);
    }

    private void extract(LocalDateTime condition) {
        if (this.saveData.size() == 0) {
            return;
        }
        LocalDateTime windowPeriod = this.getOldWindowPeriod();
        this.removeInvalidWindow(windowPeriod);
        if (windowPeriod.isBefore(condition)) {
            LogUtils.info((Logger)log, (String)"\u5230\u8fbe\u65f6\u95f4\u7a97\u53e3\u671f [{}] [{}]", (Object[])new Object[]{windowPeriod, JsonUtil.toJsonString(this.saveData)});
            this.doHandlerListener(windowPeriod);
        }
    }

    private void clear(LocalDateTime windowPeriod, ConcurrentLinkedQueue<T> list) {
        this.saveData.get(windowPeriod).removeAll(list);
    }

    public void start() {
        this.threadPoolExecutor.scheduleAtFixedRate(() -> {
            try {
                this.extract(LocalDateTime.now().minus(this.duration, this.chronoUnit));
            }
            catch (Exception e) {
                log.error("\u6ed1\u52a8\u7a97\u53e3\u5f02\u5e38", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void end() {
        for (LocalDateTime windowPeriod : this.saveData.keySet()) {
            this.doHandlerListener(windowPeriod);
        }
    }

    public static class Builder<T> {
        private Integer totalThreshold = 10;
        private Integer windowTotalThreshold = 5;
        private List<Listener<T>> listeners;
        private ScheduledExecutorService threadPoolExecutor;
        private long duration = 10L;
        private ChronoUnit chronoUnit = ChronoUnit.SECONDS;

        public static <T> Builder<T> newBuilder() {
            return new Builder<T>();
        }

        public Builder<T> withTotalThreshold(int totalThreshold) {
            Assert.isTrue((totalThreshold > 0 ? 1 : 0) != 0, (String)"\u603b\u91cf\u7a97\u53e3\u671f\u9608\u503c\u4e0d\u80fd\u5c0f\u4e8e0");
            this.totalThreshold = totalThreshold;
            return this;
        }

        public Builder<T> withWindowTotalThreshold(int windowTotalThreshold) {
            Assert.isTrue((windowTotalThreshold > 0 ? 1 : 0) != 0, (String)"\u7a97\u53e3\u6570\u91cf\u9608\u503c\u4e0d\u80fd\u5c0f\u4e8e0");
            this.windowTotalThreshold = windowTotalThreshold;
            return this;
        }

        public Builder<T> withListener(Listener<T> listener) {
            if (CollectionUtils.isEmpty(this.listeners)) {
                this.listeners = new ArrayList<Listener<T>>();
            }
            this.listeners.add(listener);
            return this;
        }

        public Builder<T> withDuration(long duration, ChronoUnit chronoUnit) {
            Assert.isTrue((duration > 0L ? 1 : 0) != 0, (String)"\u7a97\u53e3\u671f\u4e0d\u80fd\u5c0f\u4e8e0");
            this.duration = duration;
            this.chronoUnit = chronoUnit;
            return this;
        }

        public Builder<T> withScheduledExecutorServiced(ScheduledExecutorService threadPoolExecutor) {
            this.threadPoolExecutor = threadPoolExecutor;
            return this;
        }

        public SlidingWindow<T> build() {
            if (Objects.isNull(this.threadPoolExecutor)) {
                this.threadPoolExecutor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "sliding-window-thread"));
            }
            if (CollectionUtils.isEmpty(this.listeners)) {
                this.listeners = Collections.EMPTY_LIST;
            }
            return new SlidingWindow<T>(this.totalThreshold, this.windowTotalThreshold, this.listeners, this.threadPoolExecutor, this.duration, this.chronoUnit);
        }
    }
}

