/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.spring.adaptive;

import com.aizuda.bpm.engine.assist.Assert;
import com.aizuda.bpm.engine.handler.FlowJsonHandler;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public class FlowJacksonHandler
implements FlowJsonHandler {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public String toJson(Object object) {
        if (null == object) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw Assert.throwable((Throwable)e);
        }
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) {
        if (null == jsonString || null == clazz) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(jsonString, clazz);
        }
        catch (JsonProcessingException e) {
            throw Assert.throwable((Throwable)e);
        }
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

