/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.context;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SnailSpringContext
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SnailSpringContext.class);
    private static ConfigurableListableBeanFactory FACTORY;
    private static ApplicationContext CONTEXT;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        FACTORY = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        CONTEXT = applicationContext;
    }

    public static ListableBeanFactory getBeanFactory() {
        ApplicationContext factory;
        Object object = factory = null == FACTORY ? CONTEXT : FACTORY;
        if (null == factory) {
            throw new RuntimeException("No ConfigurableListableBeanFactory or ApplicationContext injected, maybe not in the Spring environment?");
        }
        return factory;
    }

    public static ApplicationContext getContext() {
        return CONTEXT;
    }

    public static <T> T getBeanByType(Class<T> clazz) {
        return (T)SnailSpringContext.getBeanFactory().getBean(clazz);
    }

    public static synchronized <T> T getBean(String name) {
        try {
            return (T)SnailSpringContext.getBeanFactory().getBean(name);
        }
        catch (NullPointerException | BeansException exception) {
            log.error(" BeanName:{} not exist\uff0cException => {}", (Object)name, (Object)exception.getMessage());
            return null;
        }
    }

    public static synchronized <T> T getBean(Class<T> requiredType) {
        try {
            return (T)SnailSpringContext.getBeanFactory().getBean(requiredType);
        }
        catch (NullPointerException | BeansException exception) {
            log.error(" BeanName:{} not exist\uff0cException => {}", (Object)requiredType.getName(), (Object)exception.getMessage());
            return null;
        }
    }

    public static synchronized <T> T getBean(String name, Class<T> requiredType) {
        try {
            return (T)SnailSpringContext.getBeanFactory().getBean(name, requiredType);
        }
        catch (NullPointerException | BeansException exception) {
            log.error(" BeanName:{} not exist\uff0cException => {}", (Object)name, (Object)exception.getMessage());
            return null;
        }
    }
}

