/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch;

import com.aizuda.snailjob.client.model.request.RetryCallbackRequest;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.JobLogMetaDTO;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.dto.RetryLogMetaDTO;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.common.rpc.client.SnailJobRetryListener;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.client.RetryRpcClient;
import com.aizuda.snailjob.server.retry.task.dto.RequestCallbackExecutorDTO;
import com.aizuda.snailjob.server.retry.task.dto.RetryExecutorResultDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskLogConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.google.common.collect.Maps;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="RealCallbackExecutorActor")
@Scope(value="prototype")
public class RequestCallbackClientActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestCallbackClientActor.class);
    private final RetryTaskMapper retryTaskMapper;
    private final RetryMapper retryMapper;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RequestCallbackExecutorDTO.class, executorDTO -> {
            try {
                this.doCallback((RequestCallbackExecutorDTO)executorDTO);
            }
            catch (Exception e) {
                log.error("Client request exception occurred", (Throwable)e);
            }
        }).build();
    }

    private void doCallback(RequestCallbackExecutorDTO executorDTO) {
        long nowMilli = DateUtils.toNowMilli();
        RegisterNodeInfo registerNodeInfo = CacheRegisterTable.getServerNode((String)executorDTO.getGroupName(), (String)executorDTO.getNamespaceId(), (String)executorDTO.getClientId());
        if (Objects.isNull(registerNodeInfo)) {
            RequestCallbackClientActor.taskExecuteFailure(executorDTO, "Client does not exist");
            JobLogMetaDTO jobLogMetaDTO = RetryTaskConverter.INSTANCE.toJobLogDTO(executorDTO);
            jobLogMetaDTO.setTimestamp(Long.valueOf(nowMilli));
            SnailJobLog.REMOTE.error("RetryTaskId:[{}] Task scheduling failed. Reason: No executable client <|>{}<|>", new Object[]{executorDTO.getRetryTaskId(), jobLogMetaDTO});
            return;
        }
        RetryCallbackRequest retryCallbackRequest = RetryTaskConverter.INSTANCE.toRetryCallbackDTO(executorDTO);
        Retry retry = (Retry)this.retryMapper.selectOne((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{Retry::getRetryStatus, Retry::getId}).eq(Retry::getId, (Object)executorDTO.getParentId()));
        if (Objects.isNull(retry)) {
            JobLogMetaDTO jobLogMetaDTO = RetryTaskConverter.INSTANCE.toJobLogDTO(executorDTO);
            jobLogMetaDTO.setTimestamp(Long.valueOf(nowMilli));
            SnailJobLog.REMOTE.error("RetryTaskId:[{}] Task scheduling failed. Reason: Retry task does not exist <|>{}<|>", new Object[]{executorDTO.getRetryTaskId(), jobLogMetaDTO});
            return;
        }
        retryCallbackRequest.setRetryStatus(retry.getRetryStatus());
        try {
            RetryRpcClient rpcClient = this.buildRpcClient(registerNodeInfo, executorDTO);
            Result<Boolean> dispatch = rpcClient.callback(retryCallbackRequest);
            if (dispatch.getStatus() == StatusEnum.YES.getStatus().intValue()) {
                SnailJobLog.LOCAL.info("RetryTaskId:[{}] Task scheduled successfully.", new Object[]{executorDTO.getRetryTaskId()});
            } else {
                SnailJobLog.LOCAL.error("RetryTaskId:[{}] Task scheduling failed. Msg:[{}]", new Object[]{executorDTO.getRetryTaskId(), dispatch.getMessage()});
                RequestCallbackClientActor.taskExecuteFailure(executorDTO, dispatch.getMessage());
            }
        }
        catch (Exception e) {
            Throwable throwable;
            if (e.getClass().isAssignableFrom(RetryException.class)) {
                re = (RetryException)e;
                throwable = re.getLastFailedAttempt().getExceptionCause();
            } else if (e.getClass().isAssignableFrom(UndeclaredThrowableException.class)) {
                re = (UndeclaredThrowableException)e;
                throwable = ((UndeclaredThrowableException)re).getUndeclaredThrowable();
            } else {
                throwable = e;
            }
            RetryLogMetaDTO retryTaskLogDTO = RetryTaskLogConverter.INSTANCE.toRetryLogMetaDTO(executorDTO);
            retryTaskLogDTO.setTimestamp(Long.valueOf(nowMilli));
            SnailJobLog.REMOTE.error("RetryTaskId:[{}] Task scheduling failed. <|>{}<|>", new Object[]{retryTaskLogDTO.getRetryTaskId(), retryTaskLogDTO, throwable});
            RequestCallbackClientActor.taskExecuteFailure(executorDTO, throwable.getMessage());
        }
    }

    private RetryRpcClient buildRpcClient(RegisterNodeInfo registerNodeInfo, RequestCallbackExecutorDTO executorDTO) {
        return (RetryRpcClient)RequestBuilder.newBuilder().nodeInfo(registerNodeInfo).failRetry(true).failover(true).retryTimes(3).retryInterval(1).routeKey(executorDTO.getRouteKey().intValue()).allocKey(String.valueOf(executorDTO.getRetryTaskId())).retryListener((RetryListener)new RetryExecutorRetryListener(executorDTO)).client(RetryRpcClient.class).build();
    }

    private static void taskExecuteFailure(RequestCallbackExecutorDTO executorDTO, String message) {
        ActorRef actorRef = ActorGenerator.retryTaskExecutorResultActor();
        RetryExecutorResultDTO executorResultDTO = RetryTaskConverter.INSTANCE.toRetryExecutorResultDTO(executorDTO);
        executorResultDTO.setExceptionMsg(message);
        executorResultDTO.setTaskStatus(RetryTaskStatusEnum.FAIL.getStatus());
        actorRef.tell((Object)executorResultDTO, actorRef);
    }

    @Generated
    public RequestCallbackClientActor(RetryTaskMapper retryTaskMapper, RetryMapper retryMapper) {
        this.retryTaskMapper = retryTaskMapper;
        this.retryMapper = retryMapper;
    }

    public class RetryExecutorRetryListener
    implements SnailJobRetryListener {
        private final Map<String, Object> properties;
        private final RequestCallbackExecutorDTO executorDTO;

        public RetryExecutorRetryListener(RequestCallbackExecutorDTO executorDTO) {
            this.executorDTO = executorDTO;
            this.properties = Maps.newHashMap();
        }

        public <V> void onRetry(Attempt<V> attempt) {
            if (attempt.getAttemptNumber() > 1L) {
                String hostId = (String)this.properties.get("HOST_ID");
                String hostIp = (String)this.properties.get("HOST_IP");
                Integer hostPort = (Integer)this.properties.get("HOST_PORT");
                RetryTask retryTask = new RetryTask();
                retryTask.setId(this.executorDTO.getRetryTaskId());
                RegisterNodeInfo realNodeInfo = new RegisterNodeInfo();
                realNodeInfo.setHostIp(hostIp);
                realNodeInfo.setHostPort(Integer.valueOf(hostPort));
                realNodeInfo.setHostId(hostId);
                retryTask.setClientInfo(ClientInfoUtils.generate((RegisterNodeInfo)realNodeInfo));
                RequestCallbackClientActor.this.retryTaskMapper.updateById((Object)retryTask);
            }
        }

        public Map<String, Object> properties() {
            return this.properties;
        }
    }
}

