/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.handler;

import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class RateLimiterHandler
implements InitializingBean {
    private final SystemProperties systemProperties;
    private RateLimiter rateLimiter;

    public boolean tryAcquire(int permits) {
        return this.rateLimiter.tryAcquire(permits, 500L, TimeUnit.MILLISECONDS);
    }

    public void refreshRate() {
        int maxDispatchCapacity = this.systemProperties.getMaxDispatchCapacity();
        if ((double)maxDispatchCapacity == this.rateLimiter.getRate()) {
            return;
        }
        this.rateLimiter.setRate((double)maxDispatchCapacity);
    }

    public void refreshRate(int maxDispatchCapacity) {
        if ((double)maxDispatchCapacity == this.rateLimiter.getRate()) {
            return;
        }
        this.rateLimiter.setRate((double)maxDispatchCapacity);
    }

    public void afterPropertiesSet() throws Exception {
        this.rateLimiter = RateLimiter.create((double)this.systemProperties.getMaxDispatchCapacity());
    }

    @Generated
    public RateLimiterHandler(SystemProperties systemProperties) {
        this.systemProperties = systemProperties;
    }
}

