/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.nio.ByteBuffer;
import javax.xml.bind.DatatypeConverter;
import org.apache.flink.annotation.Public;
import org.apache.flink.util.AbstractID;

@Public
public final class JobID
extends AbstractID {
    private static final long serialVersionUID = 1L;

    public JobID() {
    }

    public JobID(long lowerPart, long upperPart) {
        super(lowerPart, upperPart);
    }

    public JobID(byte[] bytes) {
        super(bytes);
    }

    public static JobID generate() {
        return new JobID();
    }

    public static JobID fromByteArray(byte[] bytes) {
        return new JobID(bytes);
    }

    public static JobID fromByteBuffer(ByteBuffer buf) {
        long lower = buf.getLong();
        long upper = buf.getLong();
        return new JobID(lower, upper);
    }

    public static JobID fromHexString(String hexString) {
        try {
            return new JobID(DatatypeConverter.parseHexBinary((String)hexString));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse JobID from \"" + hexString + "\".", e);
        }
    }
}

