/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.accumulators.Accumulator;

public abstract class AbstractAccumulatorRegistry {
    protected final Map<String, Accumulator<?, ?>> userAccumulators = new ConcurrentHashMap(4);

    public <V, A extends Serializable> void addAccumulator(String name, Accumulator<V, A> accumulator) {
        if (this.userAccumulators.containsKey(name)) {
            throw new UnsupportedOperationException("The accumulator '" + name + "' already exists and cannot be added.");
        }
        this.userAccumulators.put(name, accumulator);
    }

    public Map<String, Accumulator<?, ?>> getAccumulators() {
        return Collections.unmodifiableMap(this.userAccumulators);
    }

    public abstract <V, A extends Serializable> void addPreAggregatedAccumulator(String var1, Accumulator<V, A> var2);

    public abstract Map<String, Accumulator<?, ?>> getPreAggregatedAccumulators();

    public abstract void commitPreAggregatedAccumulator(String var1);

    public abstract <V, A extends Serializable> CompletableFuture<Accumulator<V, A>> queryPreAggregatedAccumulator(String var1);
}

