/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.blockcompression;

import java.nio.ByteBuffer;
import org.apache.flink.api.common.io.blockcompression.DataCorruptionException;
import org.apache.flink.api.common.io.blockcompression.InsufficientBufferException;
import org.apache.flink.util.Preconditions;

public abstract class AbstractBlockDecompressor {
    private byte[] reuseSrcHeapBuff;
    private byte[] reuseDstHeapBuff;

    public int decompress(ByteBuffer src, ByteBuffer dst) throws DataCorruptionException, InsufficientBufferException {
        return this.decompress(src, 0, src.remaining(), dst, 0);
    }

    public int decompress(ByteBuffer src, int srcOff, int srcLen, ByteBuffer dst, int dstOff) throws DataCorruptionException, InsufficientBufferException {
        int dstArrOff;
        byte[] dstArr;
        int srcArrOff;
        byte[] srcArr;
        Preconditions.checkArgument(srcOff >= 0, "source offset shouldn't be negative.");
        Preconditions.checkArgument(dstOff >= 0, "destination offset shouldn't be negative");
        if (srcOff > 0) {
            src.position(src.position() + srcOff);
        }
        if (dstOff > 0) {
            dst.position(dst.position() + dstOff);
        }
        if (src.hasArray()) {
            srcArr = src.array();
            srcArrOff = src.arrayOffset() + src.position();
            src.position(src.position() + srcLen);
        } else {
            if (this.reuseSrcHeapBuff == null || this.reuseSrcHeapBuff.length < srcLen) {
                this.reuseSrcHeapBuff = new byte[srcLen];
            }
            srcArr = this.reuseSrcHeapBuff;
            srcArrOff = 0;
            src.get(srcArr, 0, srcLen);
        }
        if (dst.hasArray()) {
            dstArr = dst.array();
            dstArrOff = dst.arrayOffset() + dst.position();
        } else {
            int len = dst.capacity() - dst.position();
            if (this.reuseDstHeapBuff == null || this.reuseDstHeapBuff.length < len) {
                this.reuseDstHeapBuff = new byte[len];
            }
            dstArr = this.reuseDstHeapBuff;
            dstArrOff = 0;
        }
        int decompressedLen = this.decompress(srcArr, srcArrOff, srcLen, dstArr, dstArrOff);
        if (dst.hasArray()) {
            dst.position(dst.position() + decompressedLen);
        } else {
            dst.put(dstArr, dstArrOff, decompressedLen);
        }
        return decompressedLen;
    }

    public int decompress(byte[] src, byte[] dst) throws DataCorruptionException, InsufficientBufferException {
        return this.decompress(src, 0, src.length, dst, 0);
    }

    public abstract int decompress(byte[] var1, int var2, int var3, byte[] var4, int var5) throws DataCorruptionException, InsufficientBufferException;
}

