/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.blockcompression;

import org.apache.flink.api.common.io.blockcompression.BlockCompressionFactory;
import org.apache.flink.api.common.io.blockcompression.Bzip2BlockCompressionFactory;
import org.apache.flink.api.common.io.blockcompression.GzipBlockCompressionFactory;
import org.apache.flink.api.common.io.blockcompression.Lz4BlockCompressionFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.util.Preconditions;

public class BlockCompressionFactoryLoader {
    public static BlockCompressionFactory createBlockCompressionFactory(String compressionFactoryName, Configuration configuration) {
        BlockCompressionFactory blockCompressionFactory;
        block13: {
            block12: {
                CompressionMethod compressionMethod;
                Preconditions.checkNotNull(compressionFactoryName);
                Preconditions.checkNotNull(configuration);
                try {
                    compressionMethod = CompressionMethod.valueOf(compressionFactoryName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    compressionMethod = null;
                }
                blockCompressionFactory = null;
                if (compressionMethod == null) break block12;
                switch (compressionMethod) {
                    case LZ4: {
                        blockCompressionFactory = new Lz4BlockCompressionFactory();
                        break block13;
                    }
                    case BZIP2: {
                        blockCompressionFactory = new Bzip2BlockCompressionFactory();
                        break block13;
                    }
                    case GZIP: {
                        blockCompressionFactory = new GzipBlockCompressionFactory();
                        break block13;
                    }
                    default: {
                        throw new IllegalStateException("Unknown CompressionMethod " + (Object)((Object)compressionMethod));
                    }
                }
            }
            Object factoryObj = null;
            try {
                factoryObj = Class.forName(compressionFactoryName).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalConfigurationException("Cannot load class " + compressionFactoryName, e);
            }
            catch (Exception e) {
                throw new IllegalConfigurationException("Cannot create object for class " + compressionFactoryName, e);
            }
            if (factoryObj instanceof BlockCompressionFactory) {
                blockCompressionFactory = factoryObj;
            } else {
                throw new IllegalArgumentException(TaskManagerOptions.TASK_EXTERNAL_SHUFFLE_COMPRESSION_CODEC.key() + " should inherit from interface BlockCompressionFactory, or use the default compression codec.");
            }
        }
        Preconditions.checkNotNull(blockCompressionFactory);
        blockCompressionFactory.setConfiguration(configuration);
        return blockCompressionFactory;
    }

    public static enum CompressionMethod {
        LZ4,
        BZIP2,
        GZIP;

    }
}

