/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.blockcompression;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.flink.api.common.io.blockcompression.AbstractBlockDecompressor;
import org.apache.flink.api.common.io.blockcompression.DataCorruptionException;
import org.apache.flink.api.common.io.blockcompression.InsufficientBufferException;
import org.apache.flink.api.common.io.blockcompression.ReusableByteArrayInputStream;

public class Bzip2BlockDecompressor
extends AbstractBlockDecompressor {
    private ReusableByteArrayInputStream srcStream;

    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws InsufficientBufferException, DataCorruptionException {
        try {
            if (this.srcStream == null) {
                this.srcStream = new ReusableByteArrayInputStream(src, srcOff, srcLen);
            } else {
                this.srcStream.reuse(src, srcOff, srcLen);
            }
            BZip2CompressorInputStream decompressStream = new BZip2CompressorInputStream((InputStream)this.srcStream);
            int decompressedLen = decompressStream.read(dst, dstOff, dst.length - dstOff);
            this.srcStream.close();
            decompressStream.close();
            if (decompressedLen < 0) {
                throw new DataCorruptionException("Fail to decompress, decompressedLen: " + decompressedLen);
            }
            return decompressedLen;
        }
        catch (IOException e) {
            throw new DataCorruptionException(e);
        }
    }
}

