/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.blockcompression;

import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.util.SafeUtils;
import org.apache.flink.api.common.io.blockcompression.AbstractBlockDecompressor;
import org.apache.flink.api.common.io.blockcompression.DataCorruptionException;
import org.apache.flink.api.common.io.blockcompression.InsufficientBufferException;

public class Lz4BlockDecompressor
extends AbstractBlockDecompressor {
    private final LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();

    @Override
    public int decompress(ByteBuffer src, int srcOff, int srcLen, ByteBuffer dst, int dstOff) throws DataCorruptionException {
        int prevSrcOff = src.position() + srcOff;
        int prevDstOff = dst.position() + dstOff;
        int compressedLen = src.getInt(prevSrcOff);
        int originalLen = src.getInt(prevSrcOff + 4);
        if (originalLen < 0 || compressedLen < 0 || originalLen == 0 && compressedLen != 0 || originalLen != 0 && compressedLen == 0) {
            throw new DataCorruptionException("Input is corrupted, invalid length.");
        }
        if (dst.capacity() - prevDstOff < originalLen) {
            throw new InsufficientBufferException("Buffer length too small");
        }
        if (src.limit() - prevSrcOff - 8 < compressedLen) {
            throw new DataCorruptionException("Source data is not integral for decompression.");
        }
        try {
            int compressedLen2 = this.decompressor.decompress(src, prevSrcOff + 8, dst, prevDstOff, originalLen);
            if (compressedLen != compressedLen2) {
                throw new DataCorruptionException("Input is corrupted, unexpected compressed length.");
            }
            src.position(prevSrcOff + compressedLen + 8);
            dst.position(prevDstOff + originalLen);
        }
        catch (LZ4Exception e) {
            throw new DataCorruptionException("Input is corrupted", e);
        }
        return originalLen;
    }

    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws InsufficientBufferException, DataCorruptionException {
        int compressedLen = SafeUtils.readIntLE((byte[])src, (int)srcOff);
        int originalLen = SafeUtils.readIntLE((byte[])src, (int)(srcOff + 4));
        if (originalLen < 0 || compressedLen < 0 || originalLen == 0 && compressedLen != 0 || originalLen != 0 && compressedLen == 0) {
            throw new DataCorruptionException("Input is corrupted, invalid length.");
        }
        if (dst.length - dstOff < originalLen) {
            throw new InsufficientBufferException("Buffer length too small");
        }
        if (src.length - srcOff - 8 < compressedLen) {
            throw new DataCorruptionException("Source data is not integral for decompression.");
        }
        try {
            int compressedLen2 = this.decompressor.decompress(src, srcOff + 8, dst, dstOff, originalLen);
            if (compressedLen != compressedLen2) {
                throw new DataCorruptionException("Input is corrupted");
            }
        }
        catch (LZ4Exception e) {
            throw new DataCorruptionException("Input is corrupted", e);
        }
        return originalLen;
    }
}

