/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.resources.GPUResource;
import org.apache.flink.api.common.resources.Resource;

@Internal
public class ResourceSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ResourceSpec DEFAULT = new ResourceSpec(0.0, 0, 0, 0, 0, new Resource[0]);
    public static final String GPU_NAME = "GPU";
    public static final String MANAGED_MEMORY_NAME = "MANAGED_MEMORY_MB";
    public static final String FLOATING_MANAGED_MEMORY_NAME = "FLOATING_MANAGED_MEMORY_MB";
    private final double cpuCores;
    private final int heapMemoryInMB;
    private final int directMemoryInMB;
    private final int nativeMemoryInMB;
    private final int stateSizeInMB;
    private final Map<String, Resource> extendedResources = new HashMap<String, Resource>(1);

    protected ResourceSpec(double cpuCores, int heapMemoryInMB, int directMemoryInMB, int nativeMemoryInMB, int stateSizeInMB, Resource ... extendedResources) {
        this.cpuCores = cpuCores;
        this.heapMemoryInMB = heapMemoryInMB;
        this.directMemoryInMB = directMemoryInMB;
        this.nativeMemoryInMB = nativeMemoryInMB;
        this.stateSizeInMB = stateSizeInMB;
        for (Resource resource : extendedResources) {
            if (resource == null) continue;
            this.extendedResources.put(resource.getName(), resource);
        }
    }

    public ResourceSpec merge(ResourceSpec other) {
        ResourceSpec target = new ResourceSpec(Math.max(this.cpuCores, other.cpuCores), this.heapMemoryInMB + other.heapMemoryInMB, this.directMemoryInMB + other.directMemoryInMB, this.nativeMemoryInMB + other.nativeMemoryInMB, this.stateSizeInMB + other.stateSizeInMB, new Resource[0]);
        target.extendedResources.putAll(this.extendedResources);
        for (Resource resource : other.extendedResources.values()) {
            target.extendedResources.merge(resource.getName(), resource, (v1, v2) -> v1.merge((Resource)v2));
        }
        return target;
    }

    public double getCpuCores() {
        return this.cpuCores;
    }

    public int getHeapMemory() {
        return this.heapMemoryInMB;
    }

    public int getDirectMemory() {
        return this.directMemoryInMB;
    }

    public int getNativeMemory() {
        return this.nativeMemoryInMB;
    }

    public int getStateSize() {
        return this.stateSizeInMB;
    }

    public double getGPUResource() {
        Resource gpuResource = this.extendedResources.get(GPU_NAME);
        if (gpuResource != null) {
            return gpuResource.getValue();
        }
        return 0.0;
    }

    public Map<String, Resource> getExtendedResources() {
        return this.extendedResources;
    }

    public boolean isValid() {
        if (this.cpuCores >= 0.0 && this.heapMemoryInMB >= 0 && this.directMemoryInMB >= 0 && this.nativeMemoryInMB >= 0 && this.stateSizeInMB >= 0) {
            for (Resource resource : this.extendedResources.values()) {
                if (!(resource.getValue() < 0.0)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean lessThanOrEqual(@Nonnull ResourceSpec other) {
        int cmp1 = Double.compare(this.cpuCores, other.cpuCores);
        int cmp2 = Integer.compare(this.heapMemoryInMB, other.heapMemoryInMB);
        int cmp3 = Integer.compare(this.directMemoryInMB, other.directMemoryInMB);
        int cmp4 = Integer.compare(this.nativeMemoryInMB, other.nativeMemoryInMB);
        int cmp5 = Integer.compare(this.stateSizeInMB, other.stateSizeInMB);
        if (cmp1 <= 0 && cmp2 <= 0 && cmp3 <= 0 && cmp4 <= 0 && cmp5 <= 0) {
            for (Resource resource : this.extendedResources.values()) {
                if (other.extendedResources.containsKey(resource.getName()) && other.extendedResources.get(resource.getName()).getResourceAggregateType() == resource.getResourceAggregateType() && !(other.extendedResources.get(resource.getName()).getValue() < resource.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == ResourceSpec.class) {
            ResourceSpec that = (ResourceSpec)obj;
            return this.cpuCores == that.cpuCores && this.heapMemoryInMB == that.heapMemoryInMB && this.directMemoryInMB == that.directMemoryInMB && this.nativeMemoryInMB == that.nativeMemoryInMB && this.stateSizeInMB == that.stateSizeInMB && Objects.equals(this.extendedResources, that.extendedResources);
        }
        return false;
    }

    public int hashCode() {
        long cpuBits = Double.doubleToLongBits(this.cpuCores);
        int result = (int)(cpuBits ^ cpuBits >>> 32);
        result = 31 * result + this.heapMemoryInMB;
        result = 31 * result + this.directMemoryInMB;
        result = 31 * result + this.nativeMemoryInMB;
        result = 31 * result + this.stateSizeInMB;
        result = 31 * result + this.extendedResources.hashCode();
        return result;
    }

    public String toString() {
        String extend = "";
        for (Resource resource : this.extendedResources.values()) {
            extend = extend + ", " + resource.getName() + "=" + resource.getValue();
        }
        return "ResourceSpec{cpuCores=" + this.cpuCores + ", heapMemoryInMB=" + this.heapMemoryInMB + ", directMemoryInMB=" + this.directMemoryInMB + ", nativeMemoryInMB=" + this.nativeMemoryInMB + ", stateSizeInMB=" + this.stateSizeInMB + extend + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private double cpuCores;
        private int heapMemoryInMB;
        private int directMemoryInMB;
        private int nativeMemoryInMB;
        private int stateSizeInMB;
        private final Map<String, Resource> extendedResources = new HashMap<String, Resource>();

        public Builder setCpuCores(double cpuCores) {
            this.cpuCores = cpuCores;
            return this;
        }

        public Builder setHeapMemoryInMB(int heapMemory) {
            this.heapMemoryInMB = heapMemory;
            return this;
        }

        public Builder setDirectMemoryInMB(int directMemory) {
            this.directMemoryInMB = directMemory;
            return this;
        }

        public Builder setNativeMemoryInMB(int nativeMemory) {
            this.nativeMemoryInMB = nativeMemory;
            return this;
        }

        public Builder setStateSizeInMB(int stateSize) {
            this.stateSizeInMB = stateSize;
            return this;
        }

        public Builder setGPUResource(double gpus) {
            this.extendedResources.put(ResourceSpec.GPU_NAME, new GPUResource(gpus));
            return this;
        }

        public Builder addExtendedResource(Resource ... resources) {
            for (Resource resource : resources) {
                this.extendedResources.put(resource.getName(), resource);
            }
            return this;
        }

        public ResourceSpec build() {
            return new ResourceSpec(this.cpuCores, this.heapMemoryInMB, this.directMemoryInMB, this.nativeMemoryInMB, this.stateSizeInMB, this.extendedResources.values().toArray(new Resource[0]));
        }
    }
}

