/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.restartstrategy;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.time.Time;

@PublicEvolving
public class RestartStrategies {
    public static RestartStrategyConfiguration noRestart() {
        return new NoRestartStrategyConfiguration();
    }

    public static RestartStrategyConfiguration fallBackRestart() {
        return new FallbackRestartStrategyConfiguration();
    }

    public static RestartStrategyConfiguration fixedDelayRestart(int restartAttempts, long delayBetweenAttempts) {
        return RestartStrategies.fixedDelayRestart(restartAttempts, Time.of(delayBetweenAttempts, TimeUnit.MILLISECONDS));
    }

    public static RestartStrategyConfiguration fixedDelayRestart(int restartAttempts, Time delayInterval) {
        return new FixedDelayRestartStrategyConfiguration(restartAttempts, delayInterval);
    }

    public static FailureRateRestartStrategyConfiguration failureRateRestart(int failureRate, Time failureInterval, Time delayInterval) {
        return new FailureRateRestartStrategyConfiguration(failureRate, failureInterval, delayInterval);
    }

    public static final class FallbackRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = -4441787204284085544L;

        @Override
        public String getDescription() {
            return "Cluster level default restart strategy";
        }
    }

    public static final class FailureRateRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = 1195028697539661739L;
        private final int maxFailureRate;
        private final Time failureInterval;
        private final Time delayBetweenAttemptsInterval;

        public FailureRateRestartStrategyConfiguration(int maxFailureRate, Time failureInterval, Time delayBetweenAttemptsInterval) {
            this.maxFailureRate = maxFailureRate;
            this.failureInterval = failureInterval;
            this.delayBetweenAttemptsInterval = delayBetweenAttemptsInterval;
        }

        public int getMaxFailureRate() {
            return this.maxFailureRate;
        }

        public Time getFailureInterval() {
            return this.failureInterval;
        }

        public Time getDelayBetweenAttemptsInterval() {
            return this.delayBetweenAttemptsInterval;
        }

        @Override
        public String getDescription() {
            return "Failure rate restart with maximum of " + this.maxFailureRate + " failures within interval " + this.failureInterval.toString() + " and fixed delay " + this.delayBetweenAttemptsInterval.toString();
        }
    }

    public static final class FixedDelayRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = 4149870149673363190L;
        private final int restartAttempts;
        private final Time delayBetweenAttemptsInterval;

        FixedDelayRestartStrategyConfiguration(int restartAttempts, Time delayBetweenAttemptsInterval) {
            this.restartAttempts = restartAttempts;
            this.delayBetweenAttemptsInterval = delayBetweenAttemptsInterval;
        }

        public int getRestartAttempts() {
            return this.restartAttempts;
        }

        public Time getDelayBetweenAttemptsInterval() {
            return this.delayBetweenAttemptsInterval;
        }

        public int hashCode() {
            int result = this.restartAttempts;
            result = 31 * result + (this.delayBetweenAttemptsInterval != null ? this.delayBetweenAttemptsInterval.hashCode() : 0);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FixedDelayRestartStrategyConfiguration) {
                FixedDelayRestartStrategyConfiguration other = (FixedDelayRestartStrategyConfiguration)obj;
                return this.restartAttempts == other.restartAttempts && this.delayBetweenAttemptsInterval.equals(other.delayBetweenAttemptsInterval);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Restart with fixed delay (" + this.delayBetweenAttemptsInterval + "). #" + this.restartAttempts + " restart attempts.";
        }
    }

    public static final class NoRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = -5894362702943349962L;

        @Override
        public String getDescription() {
            return "Restart deactivated.";
        }
    }

    public static abstract class RestartStrategyConfiguration
    implements Serializable {
        private static final long serialVersionUID = 6285853591578313960L;

        private RestartStrategyConfiguration() {
        }

        public abstract String getDescription();
    }
}

