/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.util.Objects;
import java.util.SortedMap;
import org.apache.flink.api.common.functions.Comparator;
import org.apache.flink.api.common.state.SortedMapState;
import org.apache.flink.api.common.state.StateBinder;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.SortedMapSerializer;
import org.apache.flink.api.java.typeutils.SortedMapTypeInfo;
import org.apache.flink.util.Preconditions;

public final class SortedMapStateDescriptor<K, V>
extends StateDescriptor<SortedMapState<K, V>, SortedMap<K, V>> {
    private static final long serialVersionUID = 1L;

    public SortedMapStateDescriptor(String name, Comparator<K> comparator, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
        super(name, new SortedMapSerializer<K, V>(comparator, keySerializer, valueSerializer), null);
    }

    public SortedMapStateDescriptor(String name, Comparator<K> comparator, TypeInformation<K> keyTypeInformation, TypeInformation<V> valueTypeInformation) {
        super(name, new SortedMapTypeInfo<K, V>(keyTypeInformation, valueTypeInformation, comparator), null);
    }

    public SortedMapStateDescriptor(String name, Comparator<K> comparator, Class<K> keyClass, Class<V> valueClass) {
        super(name, new SortedMapTypeInfo<K, V>(keyClass, valueClass, comparator), null);
    }

    @Override
    public SortedMapState<K, V> bind(StateBinder stateBinder) throws Exception {
        return stateBinder.createSortedMapState(this);
    }

    public SortedMapSerializer<K, V> getSerializer() {
        TypeSerializer sortedMapSerializer = super.getSerializer();
        Preconditions.checkState(sortedMapSerializer instanceof SortedMapSerializer);
        return (SortedMapSerializer)sortedMapSerializer;
    }

    public TypeInformation<SortedMap<K, V>> getTypeInformation() {
        return this.typeInfo;
    }

    public TypeSerializer<K> getKeySerializer() {
        TypeSerializer rawSerializer = this.getSerializer();
        if (!(rawSerializer instanceof SortedMapSerializer)) {
            throw new IllegalStateException("Unexpected serializer type.");
        }
        return ((SortedMapSerializer)rawSerializer).getKeySerializer();
    }

    public TypeSerializer<V> getValueSerializer() {
        TypeSerializer rawSerializer = this.getSerializer();
        if (!(rawSerializer instanceof SortedMapSerializer)) {
            throw new IllegalStateException("Unexpected serializer type.");
        }
        return ((SortedMapSerializer)rawSerializer).getValueSerializer();
    }

    @Override
    public StateDescriptor.Type getType() {
        return StateDescriptor.Type.SORTEDMAP;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortedMapStateDescriptor that = (SortedMapStateDescriptor)o;
        return this.name.equals(that.name) && Objects.equals(this.typeInfo, that.getTypeInformation()) && Objects.equals(this.serializer, that.getSerializer());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getClass().hashCode();
        result = 31 + result + this.getTypeInformation().hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SortedMapStateDescriptor{name= " + this.getName() + ", typeSerializer=" + this.serializer + ", typeInformation=" + this.typeInfo + "}";
    }
}

