/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateBinder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class StateDescriptor<S extends State, T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String name;
    @Nullable
    protected TypeSerializer<T> serializer;
    @Nullable
    protected TypeInformation<T> typeInfo;
    @Nullable
    private String queryableStateName;
    @Nullable
    protected transient T defaultValue;

    protected StateDescriptor(String name, TypeSerializer<T> serializer, @Nullable T defaultValue) {
        this.name = Preconditions.checkNotNull(name, "name must not be null");
        this.serializer = Preconditions.checkNotNull(serializer, "serializer must not be null");
        this.defaultValue = defaultValue;
    }

    protected StateDescriptor(String name, TypeInformation<T> typeInfo, @Nullable T defaultValue) {
        this.name = Preconditions.checkNotNull(name, "name must not be null");
        this.typeInfo = Preconditions.checkNotNull(typeInfo, "type information must not be null");
        this.defaultValue = defaultValue;
    }

    protected StateDescriptor(String name, Class<T> type, @Nullable T defaultValue) {
        this.name = Preconditions.checkNotNull(name, "name must not be null");
        Preconditions.checkNotNull(type, "type class must not be null");
        try {
            this.typeInfo = TypeExtractor.createTypeInfo(type);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create the type information for '" + type.getName() + "'. The most common reason is failure to infer the generic type information, due to Java's type erasure. In that case, please pass a 'TypeHint' instead of a class to describe the type. For example, to describe 'Tuple2<String, String>' as a generic type, use 'new PravegaDeserializationSchema<>(new TypeHint<Tuple2<String, String>>(){}, serializer);'", e);
        }
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public T getDefaultValue() {
        if (this.defaultValue != null) {
            if (this.serializer != null) {
                return this.serializer.copy(this.defaultValue);
            }
            throw new IllegalStateException("Serializer not yet initialized.");
        }
        return null;
    }

    public TypeSerializer<T> getSerializer() {
        if (this.serializer != null) {
            return this.serializer.duplicate();
        }
        throw new IllegalStateException("Serializer not yet initialized.");
    }

    public void setQueryable(String queryableStateName) {
        if (this.queryableStateName != null) {
            throw new IllegalStateException("Queryable state name already set");
        }
        this.queryableStateName = Preconditions.checkNotNull(queryableStateName, "Registration name");
    }

    @Nullable
    public String getQueryableStateName() {
        return this.queryableStateName;
    }

    public boolean isQueryable() {
        return this.queryableStateName != null;
    }

    public abstract S bind(StateBinder var1) throws Exception;

    public boolean isSerializerInitialized() {
        return this.serializer != null;
    }

    public void initializeSerializerUnlessSet(ExecutionConfig executionConfig) {
        if (this.serializer == null) {
            Preconditions.checkState(this.typeInfo != null, "no serializer and no type info");
            this.serializer = this.typeInfo.createSerializer(executionConfig);
            this.typeInfo = null;
        }
    }

    public int hashCode() {
        return this.name.hashCode() + 31 * this.getClass().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o.getClass() == this.getClass()) {
            StateDescriptor that = (StateDescriptor)o;
            return this.name.equals(that.name);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.name + ", defaultValue=" + this.defaultValue + ", serializer=" + this.serializer + (this.isQueryable() ? ", queryableStateName=" + this.queryableStateName + "" : "") + '}';
    }

    public abstract Type getType();

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.defaultValue == null) {
            out.writeBoolean(false);
        } else {
            byte[] serializedDefaultValue;
            out.writeBoolean(true);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 DataOutputViewStreamWrapper outView = new DataOutputViewStreamWrapper(baos);){
                TypeSerializer<T> duplicateSerializer = this.serializer.duplicate();
                duplicateSerializer.serialize(this.defaultValue, outView);
                outView.flush();
                serializedDefaultValue = baos.toByteArray();
            }
            catch (Exception e) {
                throw new IOException("Unable to serialize default value of type " + this.defaultValue.getClass().getSimpleName() + ".", e);
            }
            out.writeInt(serializedDefaultValue.length);
            out.write(serializedDefaultValue);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block27: {
            in.defaultReadObject();
            boolean hasDefaultValue = in.readBoolean();
            if (hasDefaultValue) {
                int size = in.readInt();
                byte[] buffer = new byte[size];
                in.readFully(buffer);
                try (ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                     DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper(bais);){
                    this.defaultValue = this.serializer.deserialize(inView);
                    break block27;
                }
                catch (Exception e) {
                    throw new IOException("Unable to deserialize default value.", e);
                }
            }
            this.defaultValue = null;
        }
    }

    public static enum Type {
        UNKNOWN,
        VALUE,
        LIST,
        REDUCING,
        FOLDING,
        AGGREGATING,
        MAP,
        SORTEDMAP;

    }
}

