/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeutils.base.BigDecComparator;
import org.apache.flink.api.common.typeutils.base.BigDecSerializer;

public class BigDecimalTypeInfo
extends BasicTypeInfo<BigDecimal> {
    private static final long serialVersionUID = 1L;
    private final int precision;
    private final int scale;

    public static BigDecimalTypeInfo of(int precision, int scale) {
        return new BigDecimalTypeInfo(precision, scale);
    }

    public static BigDecimalTypeInfo of(BigDecimal value) {
        return BigDecimalTypeInfo.of(value.precision(), value.scale());
    }

    public BigDecimalTypeInfo(int precision, int scale) {
        super(BigDecimal.class, new Class[0], BigDecSerializer.INSTANCE, BigDecComparator.class);
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public String toString() {
        return String.format("Decimal(%d,%d)", this.precision(), this.scale());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BigDecimalTypeInfo)) {
            return false;
        }
        BigDecimalTypeInfo that = (BigDecimalTypeInfo)obj;
        return this.precision() == that.precision() && this.scale() == that.scale();
    }

    @Override
    public int hashCode() {
        int h0 = this.getClass().getCanonicalName().hashCode();
        return Arrays.hashCode(new int[]{h0, this.precision(), this.scale()});
    }

    @Override
    public boolean shouldAutocastTo(BasicTypeInfo<?> to) {
        return to.getTypeClass() == BigDecimal.class || super.shouldAutocastTo(to);
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }
}

