/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.TypeDeserializer;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public final class TypeDeserializerAdapter<T>
extends TypeSerializer<T>
implements TypeDeserializer<T> {
    private static final long serialVersionUID = 1L;
    private final TypeDeserializer<T> deserializer;
    private final TypeSerializer<T> serializer;

    public TypeDeserializerAdapter(TypeDeserializer<T> deserializer) {
        this.deserializer = Preconditions.checkNotNull(deserializer);
        this.serializer = null;
    }

    public TypeDeserializerAdapter(TypeSerializer<T> serializer) {
        this.deserializer = null;
        this.serializer = Preconditions.checkNotNull(serializer);
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        return this.deserializer != null ? this.deserializer.deserialize(source) : this.serializer.deserialize(source);
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.deserializer != null ? this.deserializer.deserialize(reuse, source) : this.serializer.deserialize(reuse, source);
    }

    @Override
    public TypeSerializer<T> duplicate() {
        return this.deserializer != null ? this.deserializer.duplicate() : this.serializer.duplicate();
    }

    @Override
    public int getLength() {
        return this.deserializer != null ? this.deserializer.getLength() : this.serializer.getLength();
    }

    @Override
    public boolean equals(Object obj) {
        return this.deserializer != null ? this.deserializer.equals(obj) : this.serializer.equals(obj);
    }

    @Override
    public boolean canEqual(Object obj) {
        return this.deserializer != null ? this.deserializer.canEqual(obj) : this.serializer.canEqual(obj);
    }

    @Override
    public int hashCode() {
        return this.deserializer != null ? this.deserializer.hashCode() : this.serializer.hashCode();
    }

    @Override
    public boolean isImmutableType() {
        throw new UnsupportedOperationException("This is a TypeDeserializerAdapter used only for deserialization; this method should not be used.");
    }

    @Override
    public T createInstance() {
        throw new UnsupportedOperationException("This is a TypeDeserializerAdapter used only for deserialization; this method should not be used.");
    }

    @Override
    public T copy(T from) {
        throw new UnsupportedOperationException("This is a TypeDeserializerAdapter used only for deserialization; this method should not be used.");
    }

    @Override
    public T copy(T from, T reuse) {
        throw new UnsupportedOperationException("This is a TypeDeserializerAdapter used only for deserialization; this method should not be used.");
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException("This is a TypeDeserializerAdapter used only for deserialization; this method should not be used.");
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException("This is a TypeDeserializerAdapter used only for deserialization; this method should not be used.");
    }

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        throw new UnsupportedOperationException("This is a TypeDeserializerAdapter used only for deserialization; this method should not be used.");
    }

    @Override
    public CompatibilityResult<T> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        throw new UnsupportedOperationException("This is a TypeDeserializerAdapter used only for deserialization; this method should not be used.");
    }
}

