/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

abstract class AbstractMapSerializer<K, V, M extends Map<K, V>>
extends TypeSerializer<M> {
    private static final long serialVersionUID = 1L;
    final TypeSerializer<K> keySerializer;
    final TypeSerializer<V> valueSerializer;

    AbstractMapSerializer(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
        Preconditions.checkNotNull(keySerializer, "The key serializer must not be null");
        Preconditions.checkNotNull(valueSerializer, "The value serializer must not be null.");
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public M copy(M from) {
        Map newMap = (Map)this.createInstance();
        for (Map.Entry entry : from.entrySet()) {
            Object newKey = entry.getKey() == null ? null : (Object)this.keySerializer.copy(entry.getKey());
            Object newValue = entry.getValue() == null ? null : (Object)this.valueSerializer.copy(entry.getValue());
            newMap.put(newKey, newValue);
        }
        return (M)newMap;
    }

    @Override
    public M copy(M from, M reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(M map, DataOutputView target) throws IOException {
        int size = map.size();
        target.writeInt(size);
        for (Map.Entry entry : map.entrySet()) {
            this.keySerializer.serialize(entry.getKey(), target);
            if (entry.getValue() == null) {
                target.writeBoolean(true);
                continue;
            }
            target.writeBoolean(false);
            this.valueSerializer.serialize(entry.getValue(), target);
        }
    }

    @Override
    public M deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        Map map = (Map)this.createInstance();
        for (int i = 0; i < size; ++i) {
            K key = this.keySerializer.deserialize(source);
            boolean isNull = source.readBoolean();
            Object value = isNull ? null : (Object)this.valueSerializer.deserialize(source);
            map.put(key, value);
        }
        return (M)map;
    }

    @Override
    public M deserialize(M reuse, DataInputView source) throws IOException {
        return (M)this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int size = source.readInt();
        target.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.keySerializer.copy(source, target);
            boolean isNull = source.readBoolean();
            target.writeBoolean(isNull);
            if (isNull) continue;
            this.valueSerializer.copy(source, target);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMapSerializer that = (AbstractMapSerializer)o;
        return this.keySerializer.equals(that.keySerializer) && this.valueSerializer.equals(that.valueSerializer);
    }

    @Override
    public int hashCode() {
        int result = this.keySerializer.hashCode();
        result = 31 * result + this.valueSerializer.hashCode();
        return result;
    }
}

